/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_16.helpers;

import com.denizenscript.denizen.nms.interfaces.WorldHelper;
import com.denizenscript.denizen.nms.v1_16.impl.BiomeNMSImpl;
import com.denizenscript.denizen.objects.BiomeTag;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.util.stream.Collectors;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.DifficultyDamageScaler;
import net.minecraft.server.v1_16_R3.EntityLiving;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldDataServer;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;

public class WorldHelperImpl
implements WorldHelper {
    public boolean isStatic(org.bukkit.World world) {
        return ((CraftWorld)world).getHandle().isClientSide;
    }

    public void setStatic(org.bukkit.World world, boolean isStatic) {
        WorldServer worldServer = ((CraftWorld)world).getHandle();
        ReflectionHelper.setFieldValue(World.class, (String)"isClientSide", (Object)worldServer, (Object)isStatic);
    }

    public float getLocalDifficulty(Location location) {
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        DifficultyDamageScaler scaler = ((CraftWorld)location.getWorld()).getHandle().getDamageScaler(pos);
        return scaler.b();
    }

    public Location getNearestBiomeLocation(Location start, BiomeTag biome) {
        BlockPosition result = ((CraftWorld)start.getWorld()).getHandle().a(((BiomeNMSImpl)biome.getBiome()).biomeBase, new BlockPosition(start.getBlockX(), start.getBlockY(), start.getBlockZ()), 6400, 8);
        if (result == null) {
            return null;
        }
        return new Location(start.getWorld(), (double)result.getX(), (double)result.getY(), (double)result.getZ());
    }

    public boolean areEnoughSleeping(org.bukkit.World world, int percentage) {
        return (Boolean)ReflectionHelper.getFieldValue(WorldServer.class, (String)"everyoneSleeping", (Object)((CraftWorld)world).getHandle());
    }

    public boolean areEnoughDeepSleeping(org.bukkit.World world, int percentage) {
        return ((CraftWorld)world).getHandle().getPlayers().stream().noneMatch(player -> !player.isSpectator() && !player.isDeeplySleeping() && !player.fauxSleeping);
    }

    public int getSkyDarken(org.bukkit.World world) {
        return ((CraftWorld)world).getHandle().c();
    }

    public boolean isDay(org.bukkit.World world) {
        return ((CraftWorld)world).getHandle().isDay();
    }

    public boolean isNight(org.bukkit.World world) {
        return ((CraftWorld)world).getHandle().isNight();
    }

    public void setDayTime(org.bukkit.World world, long time) {
        ((CraftWorld)world).getHandle().setDayTime(time);
    }

    public void wakeUpAllPlayers(org.bukkit.World world) {
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        ReflectionHelper.setFieldValue(WorldServer.class, (String)"everyoneSleeping", (Object)nmsWorld, (Object)false);
        nmsWorld.getPlayers().stream().filter(EntityLiving::isSleeping).collect(Collectors.toList()).forEach(player -> player.wakeup(false, false));
    }

    public void clearWeather(org.bukkit.World world) {
        WorldDataServer data = ((CraftWorld)world).getHandle().worldDataServer;
        data.setStorm(false);
        if (!data.hasStorm()) {
            data.setWeatherDuration(0);
        }
        data.setThundering(false);
        if (!data.isThundering()) {
            data.setThunderDuration(0);
        }
    }
}

