/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.midi.MidiUtil;
import com.denizenscript.denizen.utilities.midi.NoteBlockReceiver;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.io.File;
import java.util.List;

public class MidiCommand
extends AbstractCommand
implements Holdable {
    public MidiCommand() {
        this.setName("midi");
        this.setSyntax("midi [cancel/<file> (tempo:<#.#>) (volume:<#.#>)] (<location>/<entity>|...)");
        this.setRequiredArguments(1, 4);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("cancel") && (arg.matches("cancel") || arg.matches("stop"))) {
                scriptEntry.addObject("cancel", "true");
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("volume") && arg.matchesFloat() && arg.matchesPrefix("volume", "vol", "v")) {
                scriptEntry.addObject("volume", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("tempo") && arg.matchesFloat()) {
                scriptEntry.addObject("tempo", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("file")) {
                scriptEntry.addObject("file", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("file") && !scriptEntry.hasObject("cancel")) {
            throw new InvalidArgumentsException("Missing file (Midi name) argument!");
        }
        if (!scriptEntry.hasObject("location")) {
            scriptEntry.defaultObject("entities", Utilities.entryDefaultEntityList(scriptEntry, true));
        }
        scriptEntry.defaultObject("tempo", new ElementTag(1)).defaultObject("volume", new ElementTag(10));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        boolean cancel = scriptEntry.hasObject("cancel");
        ElementTag filePath = scriptEntry.getElement("file");
        List entities = (List)scriptEntry.getObject("entities");
        LocationTag location = (LocationTag)scriptEntry.getObjectTag("location");
        float tempo = scriptEntry.getElement("tempo").asFloat();
        float volume = scriptEntry.getElement("volume").asFloat();
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), cancel ? MidiCommand.db("cancel", true) : "", filePath, MidiCommand.db("entities", entities), location, MidiCommand.db("tempo", Float.valueOf(tempo)), MidiCommand.db("volume", Float.valueOf(volume)));
        }
        if (!cancel) {
            File file;
            String fName = scriptEntry.getElement("file").asString();
            if (!fName.endsWith(".mid")) {
                fName = fName + ".mid";
            }
            if (!Utilities.canReadFile(file = new File(Denizen.getInstance().getDataFolder(), "/midi/" + fName))) {
                Debug.echoError("Cannot read from that file path due to security settings in Denizen/config.yml.");
                return;
            }
            if (!file.exists()) {
                Debug.echoError(scriptEntry, "Invalid file " + filePath.asString());
                return;
            }
            NoteBlockReceiver rec = location != null ? MidiUtil.playMidi(file, tempo, volume, location) : MidiUtil.playMidi(file, tempo, volume, entities);
            if (rec == null) {
                Debug.echoError(scriptEntry, "Something went wrong playing a midi!");
                scriptEntry.setFinished(true);
            } else {
                rec.onFinish = () -> scriptEntry.setFinished(true);
            }
        } else {
            if (location != null) {
                MidiUtil.stopMidi(location.identify());
            } else {
                MidiUtil.stopMidi(entities);
            }
            scriptEntry.setFinished(true);
        }
    }
}

