/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_17.helpers;

import com.denizenscript.denizen.nms.interfaces.WorldHelper;
import com.denizenscript.denizen.nms.v1_17.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_17.impl.BiomeNMSImpl;
import com.denizenscript.denizen.objects.BiomeTag;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.WorldDataServer;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;

public class WorldHelperImpl
implements WorldHelper {
    @Override
    public boolean isStatic(org.bukkit.World world) {
        return ((CraftWorld)world).getHandle().y;
    }

    @Override
    public void setStatic(org.bukkit.World world, boolean isStatic) {
        WorldServer worldServer = ((CraftWorld)world).getHandle();
        ReflectionHelper.setFieldValue(World.class, ReflectionMappingsInfo.Level_isClientSide, worldServer, isStatic);
    }

    @Override
    public float getLocalDifficulty(Location location) {
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        DifficultyDamageScaler scaler = ((CraftWorld)location.getWorld()).getHandle().getDamageScaler(pos);
        return scaler.b();
    }

    @Override
    public Location getNearestBiomeLocation(Location start, BiomeTag biome) {
        BlockPosition result = ((CraftWorld)start.getWorld()).getHandle().a(((BiomeNMSImpl)biome.getBiome()).biomeBase, new BlockPosition(start.getBlockX(), start.getBlockY(), start.getBlockZ()), 6400, 8);
        if (result == null) {
            return null;
        }
        return new Location(start.getWorld(), (double)result.getX(), (double)result.getY(), (double)result.getZ());
    }

    @Override
    public boolean areEnoughSleeping(org.bukkit.World world, int percentage) {
        SleepStatus status = (SleepStatus)ReflectionHelper.getFieldValue(WorldServer.class, ReflectionMappingsInfo.ServerLevel_sleepStatus, ((CraftWorld)world).getHandle());
        return status.a(percentage);
    }

    @Override
    public boolean areEnoughDeepSleeping(org.bukkit.World world, int percentage) {
        WorldServer level = ((CraftWorld)world).getHandle();
        SleepStatus status = (SleepStatus)ReflectionHelper.getFieldValue(WorldServer.class, ReflectionMappingsInfo.ServerLevel_sleepStatus, level);
        return status.a(percentage, level.getPlayers());
    }

    @Override
    public int getSkyDarken(org.bukkit.World world) {
        return ((CraftWorld)world).getHandle().n_();
    }

    @Override
    public boolean isDay(org.bukkit.World world) {
        return ((CraftWorld)world).getHandle().isDay();
    }

    @Override
    public boolean isNight(org.bukkit.World world) {
        return ((CraftWorld)world).getHandle().isNight();
    }

    @Override
    public void setDayTime(org.bukkit.World world, long time) {
        ((CraftWorld)world).getHandle().setDayTime(time);
    }

    @Override
    public void wakeUpAllPlayers(org.bukkit.World world) {
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        SleepStatus status = (SleepStatus)ReflectionHelper.getFieldValue(WorldServer.class, ReflectionMappingsInfo.ServerLevel_sleepStatus, nmsWorld);
        status.a();
        nmsWorld.a(EntityLiving::isSleeping).forEach(player -> player.wakeup(false, false));
    }

    @Override
    public void clearWeather(org.bukkit.World world) {
        WorldDataServer data = ((CraftWorld)world).getHandle().E;
        data.setStorm(false);
        if (!data.hasStorm()) {
            data.setWeatherDuration(0);
        }
        data.setThundering(false);
        if (!data.isThundering()) {
            data.setThunderDuration(0);
        }
    }
}

