/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.nbt.CustomNBT;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.entity.ArmorStand;
import org.bukkit.inventory.EquipmentSlot;

public class EntityDisabledSlots
implements Property {
    public static final String[] handledMechs = new String[]{"disabled_slots_raw", "disabled_slots"};
    EntityTag dentity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof ArmorStand;
    }

    public static EntityDisabledSlots getFrom(ObjectTag entity) {
        if (!EntityDisabledSlots.describes(entity)) {
            return null;
        }
        return new EntityDisabledSlots((EntityTag)entity);
    }

    private EntityDisabledSlots(EntityTag entity) {
        this.dentity = entity;
    }

    private ListTag getDisabledSlots() {
        Map<EquipmentSlot, Set<Action>> map = CustomNBT.getDisabledSlots(this.dentity.getBukkitEntity());
        ListTag list = new ListTag();
        for (Map.Entry<EquipmentSlot, Set<Action>> entry : map.entrySet()) {
            for (Action action : entry.getValue()) {
                list.add(CoreUtilities.toLowerCase(entry.getKey().name() + "/" + action.name()));
            }
        }
        return list;
    }

    private MapTag getDisabledSlotsMap() {
        Map<EquipmentSlot, Set<Action>> map = CustomNBT.getDisabledSlots(this.dentity.getBukkitEntity());
        MapTag mapTag = new MapTag();
        for (Map.Entry<EquipmentSlot, Set<Action>> entry : map.entrySet()) {
            ListTag actions = new ListTag();
            for (Action action : entry.getValue()) {
                actions.addObject(new ElementTag(action));
            }
            mapTag.putObject(entry.getKey().name(), actions);
        }
        return mapTag;
    }

    @Override
    public String getPropertyString() {
        MapTag map = this.getDisabledSlotsMap();
        return map.map.isEmpty() ? null : map.identify();
    }

    @Override
    public String getPropertyId() {
        return "disabled_slots";
    }

    public static void registerTags() {
        PropertyParser.registerTag(EntityDisabledSlots.class, ObjectTag.class, "disabled_slots", (attribute, object) -> {
            if (attribute.startsWith("raw", 2)) {
                BukkitImplDeprecations.armorStandRawSlot.warn(attribute.context);
                attribute.fulfill(1);
                return new ElementTag(CustomNBT.getCustomIntNBT(object.dentity.getBukkitEntity(), "DisabledSlots"));
            }
            BukkitImplDeprecations.armorStandDisabledSlotsOldFormat.warn(attribute.context);
            return object.getDisabledSlots();
        }, new String[0]);
        PropertyParser.registerTag(EntityDisabledSlots.class, MapTag.class, "disabled_slots_data", (attribute, object) -> object.getDisabledSlotsMap(), new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("disabled_slots_raw") && mechanism.requireInteger()) {
            BukkitImplDeprecations.armorStandRawSlot.warn(mechanism.context);
            CustomNBT.addCustomNBT(this.dentity.getBukkitEntity(), "DisabledSlots", mechanism.getValue().asInt());
        }
        if (mechanism.matches("disabled_slots")) {
            if (!mechanism.hasValue()) {
                CustomNBT.removeCustomNBT(this.dentity.getBukkitEntity(), "DisabledSlots");
                return;
            }
            HashMap<EquipmentSlot, Set<Action>> map = new HashMap<EquipmentSlot, Set<Action>>();
            if (mechanism.value.canBeType(MapTag.class)) {
                MapTag input = mechanism.valueAsType(MapTag.class);
                for (Map.Entry<StringHolder, ObjectTag> entry : input.map.entrySet()) {
                    EquipmentSlot slot = new ElementTag(entry.getKey().str).asEnum(EquipmentSlot.class);
                    if (slot == null) {
                        mechanism.echoError("Invalid equipment slot specified: " + entry.getKey().str);
                        continue;
                    }
                    ListTag actionsInput = entry.getValue().asType(ListTag.class, mechanism.context);
                    HashSet<Action> actions = new HashSet<Action>();
                    for (String actionStr : actionsInput) {
                        Action action = new ElementTag(actionStr).asEnum(Action.class);
                        if (action == null) {
                            mechanism.echoError("Invalid action specified: " + actionStr);
                            continue;
                        }
                        actions.add(action);
                    }
                    map.put(slot, actions);
                }
            } else {
                BukkitImplDeprecations.armorStandDisabledSlotsOldFormat.warn(mechanism.context);
                ListTag input = mechanism.valueAsType(ListTag.class);
                for (String string : input) {
                    String[] split = string.split("/", 2);
                    EquipmentSlot slot = new ElementTag(split[0]).asEnum(EquipmentSlot.class);
                    Action action = Action.ALL;
                    if (slot == null) {
                        mechanism.echoError("Invalid equipment slot specified: " + split[0]);
                        continue;
                    }
                    if (split.length == 2 && (action = new ElementTag(split[1]).asEnum(Action.class)) == null) {
                        mechanism.echoError("Invalid action specified: " + split[1]);
                        continue;
                    }
                    Set set = map.computeIfAbsent(slot, k -> new HashSet());
                    set.add(action);
                }
            }
            CustomNBT.setDisabledSlots(this.dentity.getBukkitEntity(), map);
        }
    }

    public static enum Action {
        ALL(0),
        REMOVE(8),
        PLACE(16);

        private final int id;

        private Action(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

