/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.command;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.utilities.command.manager.Command;
import com.denizenscript.denizen.utilities.command.manager.CommandContext;
import com.denizenscript.denizen.utilities.command.manager.Paginator;
import com.denizenscript.denizen.utilities.command.manager.exceptions.CommandException;
import com.denizenscript.denizen.utilities.command.manager.messaging.Messaging;
import com.denizenscript.denizen.utilities.debugging.DebugConsoleSender;
import com.denizenscript.denizen.utilities.flags.PlayerFlagHandler;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.scripts.ScriptHelper;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.DebugSubmitter;
import java.util.Set;
import org.bukkit.command.CommandSender;

public class DenizenCommandHandler {
    @Command(aliases={"denizen"}, usage="submit", desc="Submits recorded logs triggered by /denizen debug -r", modifiers={"submit"}, min=1, max=3, permission="denizen.submit")
    public void submit(CommandContext args, CommandSender sender) throws CommandException {
        if (!CoreConfiguration.shouldRecordDebug) {
            Messaging.sendError(sender, "Use /denizen debug -r  to record debug information to be submitted");
            return;
        }
        Messaging.send(sender, "Submitting...");
        DebugSubmitter.submitCurrentRecording(s -> {
            if (s == null) {
                Messaging.sendError(sender, "Error while submitting.");
            } else if (s.equals("disabled")) {
                Messaging.sendError(sender, "Submit failed: not recording.");
            } else {
                Messaging.send(sender, "Successfully submitted to " + s);
            }
        });
    }

    @Command(aliases={"denizen"}, usage="debug (--verbose on) (--ultraverbose on)", desc="Toggles debug mode for Denizen.", modifiers={"debug", "de", "db", "dbug"}, min=1, max=5, permission="denizen.debug", flags="scbroevnipfl")
    public void debug(CommandContext args, CommandSender sender) throws CommandException {
        if (args.getFlags().isEmpty() && args.getValueFlags().isEmpty()) {
            CoreConfiguration.shouldShowDebug = !CoreConfiguration.shouldShowDebug;
            Messaging.sendInfo(sender, "Denizen debugger is now: " + (CoreConfiguration.shouldShowDebug ? "<a>ENABLED" : "<c>DISABLED") + "<f>.");
            return;
        }
        CoreConfiguration.shouldShowDebug = true;
        if (args.hasFlag('s')) {
            CoreConfiguration.debugStackTraces = !CoreConfiguration.debugStackTraces;
            Messaging.sendInfo(sender, CoreConfiguration.debugStackTraces ? "Denizen debugger is now showing caught exception stack traces." : "Denizen debugger is no longer showing caught stack traces.");
        }
        if (args.hasFlag('c')) {
            DebugConsoleSender.showColor = !DebugConsoleSender.showColor;
            Messaging.sendInfo(sender, DebugConsoleSender.showColor ? "Denizen debugger will now show color." : "Denizen debugger will no longer show color.");
        }
        if (args.hasFlag('o')) {
            CoreConfiguration.debugOverride = !CoreConfiguration.debugOverride;
            Messaging.sendInfo(sender, CoreConfiguration.debugOverride ? "Denizen debugger is now overriding 'debug: false'." : "Denizen debugger will no longer override 'debug: false'.");
        }
        if (args.hasFlag('b')) {
            CoreConfiguration.debugScriptBuilder = !CoreConfiguration.debugScriptBuilder;
            Messaging.sendInfo(sender, CoreConfiguration.debugScriptBuilder ? "Denizen debugger is now logging the ScriptBuilder." : "Denizen debugger is now hiding ScriptBuilder logging.");
        }
        if (args.hasFlag('r')) {
            if (!CoreConfiguration.debugRecordingAllowed) {
                Messaging.sendError(sender, "Not allowed to record debug currently.");
                return;
            }
            CoreConfiguration.shouldRecordDebug = !CoreConfiguration.shouldRecordDebug;
            Debug.debugRecording = new StringBuilder();
            Messaging.sendInfo(sender, CoreConfiguration.shouldRecordDebug ? "Denizen debugger is now recording. Use /denizen submit to finish." : "Denizen debugger recording disabled.");
        }
        if (args.hasFlag('e')) {
            CoreConfiguration.debugExtraInfo = !CoreConfiguration.debugExtraInfo;
            Messaging.sendInfo(sender, CoreConfiguration.debugExtraInfo ? "Denizen debugger is now showing extra internal information." : "Denizen debugger is no longer showing extra internal information.");
        }
        if (args.hasFlag('v') || args.hasValueFlag("verbose")) {
            CoreConfiguration.debugVerbose = !CoreConfiguration.debugVerbose;
            CoreConfiguration.debugUltraVerbose = false;
            Messaging.sendInfo(sender, CoreConfiguration.debugVerbose ? "Denizen debugger is now verbose." : "Denizen debugger is no longer verbose.");
        }
        if (args.hasValueFlag("ultraverbose")) {
            CoreConfiguration.debugVerbose = CoreConfiguration.debugUltraVerbose = !CoreConfiguration.debugUltraVerbose;
            Messaging.sendInfo(sender, CoreConfiguration.debugVerbose ? "Denizen debugger is now ultra-verbose." : "Denizen debugger is no longer ultra-verbose.");
        }
        if (args.hasFlag('f')) {
            CoreConfiguration.futureWarningsEnabled = !CoreConfiguration.futureWarningsEnabled;
            Messaging.sendInfo(sender, CoreConfiguration.futureWarningsEnabled ? "Denizen debugger is now showing future warnings." : "Denizen debugger will no longer show future warnings.");
        }
        if (args.hasFlag('n')) {
            CoreConfiguration.debugShouldTrim = !CoreConfiguration.debugShouldTrim;
            Messaging.sendInfo(sender, CoreConfiguration.debugShouldTrim ? "Denizen debugger is now trimming long messages." : "Denizen debugger is no longer trimming long messages.");
        }
        if (args.hasFlag('i')) {
            CoreConfiguration.debugShowSources = !CoreConfiguration.debugShowSources;
            Messaging.sendInfo(sender, CoreConfiguration.debugShowSources ? "Denizen debugger is now showing source information." : "Denizen debugger is no longer showing source information.");
        }
        if (args.hasFlag('p')) {
            NetworkInterceptHelper.enable();
            NMSHandler.debugPackets = !NMSHandler.debugPackets;
            NMSHandler.debugPacketFilter = "";
            Messaging.sendInfo(sender, NMSHandler.debugPackets ? "Denizen debugger is now showing unfiltered packet logs." : "Denizen debugger is no longer showing packet logs.");
        }
        if (args.hasValueFlag("pfilter")) {
            NetworkInterceptHelper.enable();
            NMSHandler.debugPackets = true;
            NMSHandler.debugPacketFilter = CoreUtilities.toLowerCase(args.getFlag("pfilter"));
            Messaging.sendInfo(sender, "Denizen debug packet log now enabled and filtered.");
            return;
        }
        if (args.hasFlag('l')) {
            CoreConfiguration.debugLoadingInfo = !CoreConfiguration.debugLoadingInfo;
            Messaging.sendInfo(sender, CoreConfiguration.debugLoadingInfo ? "Denizen debugger is now showing script loading information." : "Denizen debugger is no longer showing script loading information.");
        }
    }

    @Command(aliases={"denizen"}, usage="do_nothing", desc="Does nothing, for better server command handling.", modifiers={"do_nothing"}, min=1, max=3, permission="denizen.basic")
    public void do_nothing(CommandContext args, CommandSender sender) throws CommandException {
    }

    @Command(aliases={"denizen"}, usage="version", desc="Shows the currently loaded version of Denizen.", modifiers={"version"}, min=1, max=3, permission="denizen.basic")
    public void version(CommandContext args, CommandSender sender) throws CommandException {
        Messaging.sendInfo(sender, "<2>DENIZEN<7>: A high-power scripting engine for Spigot!");
        Messaging.send(sender, "");
        Messaging.send(sender, "<7>by: <f>the DenizenScript team, with help from many skilled contributors!");
        Messaging.send(sender, "<7>chat with us at: <f>https://discord.gg/Q6pZGSR");
        Messaging.send(sender, "<7>or learn more at: <f>https://denizenscript.com");
        Messaging.send(sender, "<7>version: <f>" + Denizen.versionTag + "<7>, core version: <f>" + DenizenCore.VERSION);
    }

    @Command(aliases={"denizen"}, usage="save", desc="Saves the current Denizen save data to file as needed.", modifiers={"save"}, min=1, max=3, permission="denizen.basic")
    public void save(CommandContext args, CommandSender sender) throws CommandException {
        DenizenCore.saveAll();
        Denizen.getInstance().saveSaves(false);
        Messaging.send(sender, "Denizen save data saved to file from memory.");
    }

    @Command(aliases={"denizen"}, usage="reload (saves|notes|config|scripts) (-a)", desc="Reloads various Denizen files from disk to memory.", modifiers={"reload"}, min=1, max=3, permission="denizen.basic", flags="a")
    public void reload(CommandContext args, CommandSender sender) throws CommandException {
        if (args.hasFlag('a')) {
            Denizen.getInstance().reloadConfig();
            DenizenCore.reloadScripts();
            PlayerFlagHandler.reloadAllFlagsNow();
            NoteManager.reload();
            Denizen.getInstance().reloadSaves();
            Messaging.send(sender, "Denizen save data, config, and scripts reloaded from disk to memory.");
            if (ScriptHelper.hadError()) {
                Messaging.sendError(sender, "There was an error loading your scripts, check the console for details!");
            }
            return;
        }
        if (args.length() > 2) {
            if (args.getString(1).equalsIgnoreCase("saves")) {
                Denizen.getInstance().reloadSaves();
                PlayerFlagHandler.reloadAllFlagsNow();
                Messaging.send(sender, "Denizen save data reloaded from disk to memory.");
                return;
            }
            if (args.getString(1).equalsIgnoreCase("notes")) {
                NoteManager.reload();
                Messaging.send(sender, "Denizen note data reloaded from disk to memory.");
                return;
            }
            if (args.getString(1).equalsIgnoreCase("config")) {
                Denizen.getInstance().reloadConfig();
                Messaging.send(sender, "Denizen config file reloaded from disk to memory.");
                return;
            }
            if (args.getString(1).equalsIgnoreCase("scripts")) {
                DenizenCore.reloadScripts();
                Messaging.send(sender, "Denizen/scripts/... reloaded from disk to memory.");
                if (ScriptHelper.hadError()) {
                    Messaging.sendError(sender, "There was an error loading your scripts, check the console for details!");
                }
                Messaging.sendError(sender, "'/denizen reload scripts' is the old way of doing things ... use '/ex reload' instead!");
                return;
            }
        }
        Messaging.send(sender, "");
        Messaging.send(sender, "<f>Specify which parts to reload. Valid options are: SAVES, NOTES, CONFIG, SCRIPTS");
        Messaging.send(sender, "<b>Example: /denizen reload saves");
        Messaging.send(sender, "<f>Use '-a' to reload all parts at once.");
        Messaging.send(sender, "<f>Note that you shouldn't use this command generally, instead use '/ex reload' - see also the Beginner's Guide at https://guide.denizenscript.com/");
        Messaging.send(sender, "");
    }

    @Command(aliases={"denizen"}, usage="scripts (--type assignment|task|...) (--filter string)", desc="Lists the currently loaded scripts.", modifiers={"scripts"}, min=1, max=4, permission="denizen.basic")
    public void scripts(CommandContext args, CommandSender sender) throws CommandException {
        String type = null;
        if (args.hasValueFlag("type")) {
            type = args.getFlag("type");
        }
        String filter = null;
        if (args.hasValueFlag("filter")) {
            filter = args.getFlag("filter");
        }
        Set<String> scripts = ScriptRegistry.scriptContainers.keySet();
        Paginator paginator = new Paginator().header("Scripts");
        paginator.addLine("<e>Key: <a>Type  <b>Name");
        for (String script : scripts) {
            Object scriptContainer = ScriptRegistry.getScriptContainer(script);
            if (type != null) {
                if (!((ScriptContainer)scriptContainer).getContainerType().equalsIgnoreCase(type)) continue;
                if (filter != null) {
                    if (!script.contains(filter.toUpperCase())) continue;
                    paginator.addLine("<a>" + ((ScriptContainer)scriptContainer).getContainerType().substring(0, 3) + "  <b>" + script);
                    continue;
                }
                paginator.addLine("<a>" + ((ScriptContainer)scriptContainer).getContainerType().substring(0, 3) + "  <b>" + script);
                continue;
            }
            if (filter != null) {
                if (!script.contains(filter.toUpperCase())) continue;
                paginator.addLine("<a>" + ((ScriptContainer)scriptContainer).getContainerType().substring(0, 3) + "  <b>" + script);
                continue;
            }
            paginator.addLine("<a>" + ((ScriptContainer)scriptContainer).getContainerType().substring(0, 3) + "  <b>" + script);
        }
        if (!paginator.sendPage(sender, args.getInteger(1, 1))) {
            throw new CommandException("The page " + args.getInteger(1, 1) + " does not exist!");
        }
    }
}

