/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.flags.RedirectionFlagTracker;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.shaded.org.json.JSONObject;
import java.util.List;

public class ScriptTag
implements ObjectTag,
Adjustable,
FlaggableObject {
    private ScriptContainer container;
    private String prefix = "Script";
    private String name = null;
    public static ObjectTagProcessor<ScriptTag> tagProcessor = new ObjectTagProcessor();

    @Deprecated
    public static ScriptTag valueOf(String string) {
        return ScriptTag.valueOf(string, null);
    }

    @Fetchable(value="s")
    public static ScriptTag valueOf(String string, TagContext context) {
        Object container;
        if (string.startsWith("s@")) {
            string = string.substring(2);
        }
        if ((container = ScriptRegistry.getScriptContainer(string)) == null) {
            return null;
        }
        return new ScriptTag((ScriptContainer)container);
    }

    public static boolean matches(String string) {
        if (CoreUtilities.toLowerCase(string).startsWith("s@")) {
            return true;
        }
        return ScriptRegistry.getScriptContainer(string) != null;
    }

    public ScriptTag(ScriptContainer container) {
        this.container = container;
        this.name = CoreUtilities.toLowerCase(container.getName());
    }

    public ScriptTag validate() {
        this.container = ScriptRegistry.getScriptContainer(this.name);
        return this.container != null ? this : null;
    }

    public String getType() {
        return this.container != null ? this.container.getContainerType() : "invalid";
    }

    public String getName() {
        return this.name;
    }

    public ScriptContainer getContainer() {
        return this.container;
    }

    @Override
    public String identify() {
        return "s@" + this.name;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        return "<LG>s@<Y>" + this.name + "<GR> (" + this.getType() + ")";
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public AbstractFlagTracker getFlagTracker() {
        return new RedirectionFlagTracker(DenizenCore.serverFlagMap, "__scripts." + this.name.replace(".", "&dot"));
    }

    @Override
    public void reapplyTracker(AbstractFlagTracker tracker) {
    }

    public static void registerTags() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        tagProcessor.registerStaticTag(ElementTag.class, "container_type", (attribute, object) -> new ElementTag(object.container.getContainerType()), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "name", (attribute, object) -> new ElementTag(object.name), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "relative_filename", (attribute, object) -> new ElementTag(object.container.getRelativeFileName()), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "filename", (attribute, object) -> new ElementTag(object.container.getFileName().replace("\\", "/")), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "original_name", (attribute, object) -> new ElementTag(object.container.getOriginalName()), new String[0]);
        tagProcessor.registerTag(ObjectTag.class, "constant", (attribute, object) -> {
            Deprecations.scriptConstantTag.warn(attribute.context);
            if (!attribute.hasParam()) {
                attribute.echoError("The tag ScriptTag.constant[...] must have a value.");
                return null;
            }
            YamlConfiguration section = object.getContainer().getConfigurationSection("default constants");
            if (section == null) {
                return null;
            }
            Object obj = section.get(attribute.getParam());
            if (obj == null) {
                return null;
            }
            if (obj instanceof List) {
                ListTag list = new ListTag();
                for (Object each : (List)obj) {
                    if (each == null) {
                        each = "null";
                    }
                    list.add(TagManager.tag(each.toString(), DenizenCore.implementation.getTagContext(attribute.getScriptEntry())));
                }
                return list;
            }
            return new ElementTag(TagManager.tag(obj.toString(), DenizenCore.implementation.getTagContext(attribute.getScriptEntry())));
        }, new String[0]);
        tagProcessor.registerTag(ObjectTag.class, ElementTag.class, "parsed_key", (attribute, object, key) -> {
            ScriptContainer container = object.getContainer();
            if (container == null) {
                Debug.echoError("Script '" + object.getName() + "' is missing script container?!");
                return null;
            }
            YamlConfiguration section = container.getConfigurationSection("");
            if (section == null) {
                Debug.echoError("Script '" + container.getName() + "' missing root section?!");
                return null;
            }
            Object obj = section.get(key.asString());
            if (obj == null) {
                return null;
            }
            return CoreUtilities.objectToTagForm(obj, attribute.context, true, true);
        }, new String[0]);
        tagProcessor.registerStaticTag(ObjectTag.class, ElementTag.class, "data_key", (attribute, object, key) -> {
            ScriptContainer container = object.getContainer();
            if (container == null) {
                Debug.echoError("Script '" + object.getName() + "' is missing script container?!");
                return null;
            }
            YamlConfiguration section = container.getConfigurationSection("");
            if (section == null) {
                Debug.echoError("Script '" + container.getName() + "' missing root section?!");
                return null;
            }
            Object obj = section.get(key.asString());
            if (obj == null) {
                return null;
            }
            return CoreUtilities.objectToTagForm(obj, attribute.context, true);
        }, new String[0]);
        tagProcessor.registerFutureTagDeprecation("data_key", "yaml_key");
        tagProcessor.registerStaticTag(ListTag.class, "list_keys", (attribute, object) -> {
            YamlConfiguration conf = object.getContainer().getConfigurationSection(attribute.hasParam() ? attribute.getParam() : "");
            if (conf == null) {
                return null;
            }
            return new ListTag(conf.getKeys(false));
        }, new String[0]);
        tagProcessor.registerStaticTag(ListTag.class, "list_deep_keys", (attribute, object) -> {
            YamlConfiguration conf = object.getContainer().getConfigurationSection(attribute.hasParam() ? attribute.getParam() : "");
            if (conf == null) {
                return null;
            }
            return new ListTag(conf.getKeys(true));
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "to_json", (attribute, object) -> {
            JSONObject jsobj = new JSONObject(YamlConfiguration.reverse(object.container.getContents().getMap(), true));
            jsobj.remove("type");
            return new ElementTag(jsobj.toString());
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "to_yaml", (attribute, object) -> {
            YamlConfiguration config = new YamlConfiguration();
            config.addAll(object.getContainer().getContents().getMap());
            config.set("type", null);
            return new ElementTag(config.saveToString(true));
        }, new String[0]);
        tagProcessor.registerFutureTagDeprecation("to_yaml", "to_text");
        tagProcessor.registerTag(ListTag.class, "queues", (attribute, object) -> {
            ListTag queues = new ListTag();
            for (ScriptQueue queue : ScriptQueue.getQueues()) {
                if (queue.script == null || !queue.script.getName().equals(object.getName())) continue;
                queues.addObject(new QueueTag(queue));
            }
            return queues;
        }, "list_queues");
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        mechanism.echoError("Cannot apply properties to a script!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        tagProcessor.processMechanism(this, mechanism);
    }
}

