/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class EntityHealsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag entity;
    public ElementTag reason;
    public EntityRegainHealthEvent event;

    public EntityHealsScriptEvent() {
        this.registerCouldMatcher("<entity> heals (because <'cause'>)");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.entity.tryAdvancedMatcher(path.eventArgLowerAt(0))) {
            return false;
        }
        if (path.eventArgLowerAt(2).equals("because") && !EntityHealsScriptEvent.runGenericCheck(path.eventArgLowerAt(3), this.reason.toString())) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag && ((ElementTag)determinationObj).isDouble()) {
            this.event.setAmount(((ElementTag)determinationObj).asDouble());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "entity": {
                return this.entity.getDenizenObject();
            }
            case "reason": {
                return this.reason;
            }
            case "amount": {
                return new ElementTag(this.event.getAmount());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityHeals(EntityRegainHealthEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.reason = new ElementTag(event.getRegainReason().toString());
        this.event = event;
        this.fire((Event)event);
    }
}

