/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.utilities.debugging;

import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class DebugLog
extends Logger {
    private static final DebugFormatter formatter = new DebugFormatter();
    private FileHandler handler;

    public DebugLog(String l, String f) {
        super(l, null);
        try {
            this.handler = new FileHandler(f, true);
            this.addHandler(this.handler);
            this.setLevel(Level.ALL);
            this.handler.setFormatter(formatter);
        }
        catch (Exception e) {
            System.out.println("Error creating logger '" + l + "': ");
            Debug.echoError(e);
        }
    }

    public void close() {
        if (this.handler != null) {
            this.handler.close();
        }
    }

    private static class DebugFormatter
    extends Formatter {
        private final SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ");

        private DebugFormatter() {
        }

        @Override
        public String format(LogRecord rec) {
            Throwable exception = rec.getThrown();
            String out = this.date.format(rec.getMillis());
            out = out + "[" + CoreUtilities.toUpperCase(rec.getLevel().getName()) + "] ";
            out = out + rec.getMessage() + '\n';
            if (exception != null) {
                StringWriter writer = new StringWriter();
                exception.printStackTrace(new PrintWriter(writer));
                return out + writer;
            }
            return out;
        }
    }
}

