/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;

public class HangingBreaksScriptEvent
extends BukkitScriptEvent
implements Listener {
    public ElementTag cause;
    public EntityTag entity;
    public EntityTag hanging;
    public HangingBreakEvent event;

    public HangingBreaksScriptEvent() {
        this.registerCouldMatcher("<hanging> breaks (because <'cause'>)");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String hangCheck = path.eventArgLowerAt(0);
        if (!this.hanging.tryAdvancedMatcher(hangCheck)) {
            return false;
        }
        if (path.eventArgLowerAt(2).equals("because") && !path.eventArgLowerAt(3).equals(this.cause.asLowerString())) {
            return false;
        }
        if (!this.runInCheck(path, this.hanging.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "cause": {
                return this.cause;
            }
            case "entity": {
                return this.entity;
            }
            case "hanging": {
                return this.hanging;
            }
            case "location": {
                BukkitImplDeprecations.hangingBreaksEventContext.warn();
                return this.hanging.getLocation();
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onHangingBreaks(HangingBreakEvent event) {
        this.hanging = new EntityTag((Entity)event.getEntity());
        this.cause = new ElementTag((Enum<?>)event.getCause());
        this.entity = event instanceof HangingBreakByEntityEvent ? new EntityTag(((HangingBreakByEntityEvent)event).getRemover()) : null;
        this.event = event;
        this.fire((Event)event);
    }
}

