/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.flags.RedirectionFlagTracker;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.entity.EntityType;

public class BiomeTag
implements ObjectTag,
Adjustable,
FlaggableObject {
    private BiomeNMS biome;
    String prefix = "biome";
    public static ObjectTagProcessor<BiomeTag> tagProcessor = new ObjectTagProcessor();

    @Deprecated
    public static BiomeTag valueOf(String string) {
        return BiomeTag.valueOf(string, null);
    }

    @Fetchable(value="b")
    public static BiomeTag valueOf(String string, TagContext context) {
        BiomeNMS biome;
        if (string.startsWith("b@")) {
            string = string.substring(2);
        }
        string = CoreUtilities.toLowerCase(string);
        int comma = string.indexOf(44);
        String worldName = null;
        String biomeName = string;
        if (comma != -1) {
            worldName = string.substring(0, comma);
            biomeName = string.substring(comma + 1);
        }
        World world = (World)Bukkit.getWorlds().get(0);
        if (worldName != null) {
            WorldTag worldTag = WorldTag.valueOf(worldName, context);
            if (worldTag == null || worldTag.getWorld() == null) {
                return null;
            }
            world = worldTag.getWorld();
        }
        if ((biome = NMSHandler.instance.getBiomeNMS(world, biomeName)) == null) {
            return null;
        }
        return new BiomeTag(biome);
    }

    public static boolean matches(String arg) {
        if (arg.startsWith("b@")) {
            return true;
        }
        return BiomeTag.valueOf(arg, CoreUtilities.noDebugContext) != null;
    }

    public BiomeTag(Biome biome) {
        String key = biome.name();
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17)) {
            key = biome.getKey().getNamespace().equals("minecraft") ? biome.getKey().getKey() : biome.getKey().toString();
        }
        this.biome = NMSHandler.instance.getBiomeNMS((World)Bukkit.getWorlds().get(0), key);
    }

    public BiomeTag(BiomeNMS biome) {
        this.biome = biome;
    }

    public BiomeNMS getBiome() {
        return this.biome;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String identify() {
        return "b@" + this.biome.world.getName() + "," + this.biome.getName();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
        }
        return this;
    }

    @Override
    public AbstractFlagTracker getFlagTracker() {
        return new RedirectionFlagTracker(DenizenCore.serverFlagMap, "__biomes." + this.biome.getName().replace(".", "&dot"));
    }

    @Override
    public void reapplyTracker(AbstractFlagTracker tracker) {
    }

    public static void registerTags() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        tagProcessor.registerTag(ElementTag.class, "downfall_type", (attribute, object) -> new ElementTag(object.biome.getDownfallType()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "name", (attribute, object) -> new ElementTag(CoreUtilities.toLowerCase(object.biome.getName())), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "humidity", (attribute, object) -> new ElementTag(object.biome.getHumidity()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "temperature", (attribute, object) -> new ElementTag(object.biome.getTemperature()), new String[0]);
        tagProcessor.registerTag(ListTag.class, "spawnable_entities", (attribute, object) -> {
            List<EntityType> entityTypes;
            if (attribute.startsWith("ambient", 2)) {
                BukkitImplDeprecations.biomeSpawnableTag.warn(attribute.context);
                attribute.fulfill(1);
                entityTypes = object.biome.getAmbientEntities();
            } else if (attribute.startsWith("creatures", 2)) {
                BukkitImplDeprecations.biomeSpawnableTag.warn(attribute.context);
                attribute.fulfill(1);
                entityTypes = object.biome.getCreatureEntities();
            } else if (attribute.startsWith("monsters", 2)) {
                BukkitImplDeprecations.biomeSpawnableTag.warn(attribute.context);
                attribute.fulfill(1);
                entityTypes = object.biome.getMonsterEntities();
            } else if (attribute.startsWith("water", 2)) {
                BukkitImplDeprecations.biomeSpawnableTag.warn(attribute.context);
                attribute.fulfill(1);
                entityTypes = object.biome.getWaterEntities();
            } else {
                String type = attribute.hasParam() ? CoreUtilities.toLowerCase(attribute.getParam()) : "all";
                switch (type) {
                    case "ambient": {
                        entityTypes = object.biome.getAmbientEntities();
                        break;
                    }
                    case "creatures": {
                        entityTypes = object.biome.getCreatureEntities();
                        break;
                    }
                    case "monsters": {
                        entityTypes = object.biome.getMonsterEntities();
                        break;
                    }
                    case "water": {
                        entityTypes = object.biome.getWaterEntities();
                        break;
                    }
                    default: {
                        entityTypes = object.biome.getAllEntities();
                    }
                }
            }
            ListTag list = new ListTag();
            for (EntityType entityType : entityTypes) {
                list.add(entityType.name());
            }
            return list;
        }, new String[0]);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        mechanism.echoError("Cannot apply properties to a biome!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("humidity") && mechanism.requireFloat()) {
            this.biome.setHumidity(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("temperature") && mechanism.requireFloat()) {
            this.biome.setTemperature(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("downfall_type") && mechanism.requireEnum(BiomeNMS.DownfallType.class)) {
            this.biome.setPrecipitation(BiomeNMS.DownfallType.valueOf(mechanism.getValue().asString().toUpperCase()));
        }
        tagProcessor.processMechanism(this, mechanism);
    }
}

