/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;

public class EntityArmorBonus
implements Property {
    public static final String[] handledMechs = new String[]{"armor_bonus"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).isLivingEntity();
    }

    public static EntityArmorBonus getFrom(ObjectTag entity) {
        if (!EntityArmorBonus.describes(entity)) {
            return null;
        }
        return new EntityArmorBonus((EntityTag)entity);
    }

    private EntityArmorBonus(EntityTag ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        double value = this.getAttribute().getValue();
        return value > 0.0 ? String.valueOf(value) : null;
    }

    @Override
    public String getPropertyId() {
        return "armor_bonus";
    }

    public AttributeInstance getAttribute() {
        return this.entity.getLivingEntity().getAttribute(Attribute.GENERIC_ARMOR);
    }

    public static void register() {
        PropertyParser.registerTag(EntityArmorBonus.class, ElementTag.class, "armor_bonus", (attribute, object) -> new ElementTag(object.getAttribute().getValue()), new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("armor_bonus") && mechanism.requireDouble()) {
            this.getAttribute().setBaseValue(mechanism.getValue().asDouble());
        }
    }
}

