/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.data.AnaloguePowerable;

public class MaterialPower
implements Property {
    public static final String[] handledMechs = new String[]{"power"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && ((MaterialTag)material).getModernData() instanceof AnaloguePowerable;
    }

    public static MaterialPower getFrom(ObjectTag _material) {
        if (!MaterialPower.describes(_material)) {
            return null;
        }
        return new MaterialPower((MaterialTag)_material);
    }

    private MaterialPower(MaterialTag _material) {
        this.material = _material;
    }

    public static void register() {
        PropertyParser.registerStaticTag(MaterialPower.class, ElementTag.class, "power", (attribute, material) -> new ElementTag(((AnaloguePowerable)material.material.getModernData()).getPower()), new String[0]);
        PropertyParser.registerStaticTag(MaterialPower.class, ElementTag.class, "max_power", (attribute, material) -> new ElementTag(((AnaloguePowerable)material.material.getModernData()).getMaximumPower()), new String[0]);
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(((AnaloguePowerable)this.material.getModernData()).getPower());
    }

    @Override
    public String getPropertyId() {
        return "power";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("power") && mechanism.requireInteger()) {
            int power = mechanism.getValue().asInt();
            AnaloguePowerable powerable = (AnaloguePowerable)this.material.getModernData();
            if (power < 0 || power > powerable.getMaximumPower()) {
                mechanism.echoError("Material power mechanism value '" + power + "' is not valid. Must be between 0 and " + powerable.getMaximumPower() + ".");
                return;
            }
            powerable.setPower(power);
        }
    }
}

