/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.server;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Date;
import java.util.List;
import org.bukkit.BanList;
import org.bukkit.Bukkit;

public class BanCommand
extends AbstractCommand {
    public BanCommand() {
        this.setName("ban");
        this.setSyntax("ban ({add}/remove) [<player>|.../addresses:<address>|...] (reason:<text>) (expire:<time>) (source:<text>)");
        this.setRequiredArguments(1, 5);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("addresses") && arg.matchesPrefix("addresses", "address")) {
                scriptEntry.addObject("addresses", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("reason") && arg.matchesPrefix("reason")) {
                scriptEntry.addObject("reason", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesPrefix("expire", "duration", "time", "d", "expiration")) {
                if (arg.matchesArgumentType(TimeTag.class)) {
                    scriptEntry.addObject("expire", arg.asType(TimeTag.class));
                    continue;
                }
                scriptEntry.addObject("expire", new TimeTag(TimeTag.now().millis() + arg.asType(DurationTag.class).getMillis()));
                continue;
            }
            if (!scriptEntry.hasObject("source") && arg.matchesPrefix("source")) {
                scriptEntry.addObject("source", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.limitToOnlyPrefix("action") && arg.matchesEnum(Actions.class)) {
                scriptEntry.addObject("action", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("targets") && arg.limitToOnlyPrefix("targets") && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("targets", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("action", new ElementTag("add")).defaultObject("reason", new ElementTag("Banned.")).defaultObject("source", new ElementTag("(Unknown)"));
        if (!(scriptEntry.hasObject("targets") && !((List)scriptEntry.getObject("targets")).isEmpty() || scriptEntry.hasObject("addresses") && !((List)scriptEntry.getObject("addresses")).isEmpty())) {
            throw new IllegalArgumentException("Must specify a valid target or address!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Date expiration;
        ElementTag action = scriptEntry.getElement("action");
        List targets = (List)scriptEntry.getObject("targets");
        ListTag addresses = (ListTag)scriptEntry.getObjectTag("addresses");
        ElementTag reason = scriptEntry.getElement("reason");
        TimeTag expire = (TimeTag)scriptEntry.getObjectTag("expire");
        ElementTag source = scriptEntry.getElement("source");
        Date date = expiration = expire == null ? null : new Date(expire.millis());
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), action, BanCommand.db("targets", targets), addresses, reason, expire, source);
        }
        Actions banAction = Actions.valueOf(action.toString().toUpperCase());
        switch (banAction) {
            case ADD: {
                if (targets != null) {
                    for (PlayerTag player : targets) {
                        if (!player.isValid()) continue;
                        Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(player.getName(), reason.toString(), expiration, source.toString());
                        if (!player.isOnline()) continue;
                        player.getPlayerEntity().kickPlayer(reason.toString());
                    }
                }
                if (addresses == null) break;
                for (String address : addresses) {
                    Bukkit.getBanList((BanList.Type)BanList.Type.IP).addBan(address, reason.toString(), expiration, source.toString());
                }
                break;
            }
            case REMOVE: {
                if (targets != null) {
                    for (PlayerTag player : targets) {
                        if (!player.isValid() || !player.getOfflinePlayer().isBanned()) continue;
                        Bukkit.getBanList((BanList.Type)BanList.Type.NAME).pardon(player.getName());
                    }
                }
                if (addresses == null) break;
                for (String address : addresses) {
                    Bukkit.getBanList((BanList.Type)BanList.Type.IP).pardon(address);
                }
                break;
            }
        }
    }

    public static enum Actions {
        ADD,
        REMOVE;

    }
}

