/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects;

import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public interface Adjustable
extends ObjectTag {
    public void adjust(Mechanism var1);

    default public void safeAdjust(Mechanism mechanism) {
        mechanism.adjusting = this;
        mechanism.isProperty = false;
        if (mechanism.shouldDebug()) {
            Debug.echoDebug((Debuggable)mechanism.context, "Adjust mechanism '" + mechanism.getName() + "' on object of type '" + this.getDenizenObjectType() + "'...");
        }
        this.adjust(mechanism);
        mechanism.autoReport();
    }

    default public void safeAdjustDuplicate(Mechanism mechanism) {
        this.safeAdjust(new Mechanism(mechanism.getName(), mechanism.value, mechanism.context));
    }

    public void applyProperty(Mechanism var1);

    default public void safeApplyProperty(Mechanism mechanism) {
        mechanism.adjusting = this;
        mechanism.isProperty = true;
        if (mechanism.shouldDebug()) {
            Debug.echoDebug((Debuggable)mechanism.context, "Applying property '" + mechanism.getName() + "' on object of type '" + this.getDenizenObjectType() + "'...");
            if (CoreConfiguration.debugVerbose) {
                try {
                    throw new Exception("Stack trace of property");
                }
                catch (Exception ex) {
                    Debug.echoError(ex);
                }
            }
        }
        this.applyProperty(mechanism);
        mechanism.autoReport();
    }
}

