/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_19.helpers;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.ImprovedOfflinePlayer;
import com.denizenscript.denizen.nms.enums.CustomEntityType;
import com.denizenscript.denizen.nms.interfaces.PlayerHelper;
import com.denizenscript.denizen.nms.v1_19.Handler;
import com.denizenscript.denizen.nms.v1_19.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_19.helpers.ItemHelperImpl;
import com.denizenscript.denizen.nms.v1_19.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_19.impl.ImprovedOfflinePlayerImpl;
import com.denizenscript.denizen.nms.v1_19.impl.entities.CraftFakePlayerImpl;
import com.denizenscript.denizen.nms.v1_19.impl.entities.EntityItemProjectileImpl;
import com.denizenscript.denizen.nms.v1_19.impl.network.handlers.AbstractListenerPlayInImpl;
import com.denizenscript.denizen.nms.v1_19.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.entity.DenizenEntityType;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import it.unimi.dsi.fastutil.ints.IntList;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.network.protocol.game.PacketPlayOutBoss;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo;
import net.minecraft.network.protocol.game.PacketPlayOutRecipeUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutStopSound;
import net.minecraft.network.protocol.game.PacketPlayOutTags;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.JsonListEntry;
import net.minecraft.server.players.OpList;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.World;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.SoundCategory;
import org.bukkit.boss.BossBar;
import org.bukkit.craftbukkit.v1_19_R1.CraftServer;
import org.bukkit.craftbukkit.v1_19_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R1.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R1.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerHelperImpl
extends PlayerHelper {
    public static final Field ATTACK_COOLDOWN_TICKS = ReflectionHelper.getFields(EntityLiving.class).get(ReflectionMappingsInfo.LivingEntity_attackStrengthTicker, Integer.TYPE);
    public static final Field FLY_TICKS = ReflectionHelper.getFields(PlayerConnection.class).get(ReflectionMappingsInfo.ServerGamePacketListenerImpl_aboveGroundTickCount, Integer.TYPE);
    public static final Field VEHICLE_FLY_TICKS = ReflectionHelper.getFields(PlayerConnection.class).get(ReflectionMappingsInfo.ServerGamePacketListenerImpl_aboveGroundVehicleTickCount, Integer.TYPE);
    public static final MethodHandle PLAYER_RESPAWNFORCED_SETTER = ReflectionHelper.getFinalSetter(EntityPlayer.class, (String)ReflectionMappingsInfo.ServerPlayer_respawnForced, Boolean.TYPE);
    public static final DataWatcherObject<Byte> ENTITY_HUMAN_SKINLAYERS_DATAWATCHER;

    public void stopSound(Player player, String sound, SoundCategory category) {
        ((CraftPlayer)player).getHandle().b.a((tc)new PacketPlayOutStopSound(sound == null ? null : new MinecraftKey(sound), null));
    }

    public void deTrackEntity(Player player, Entity entity) {
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        WorldServer world = (WorldServer)nmsPlayer.s;
        PlayerChunkMap.EntityTracker tracker = (PlayerChunkMap.EntityTracker)world.k().a.K.get(entity.getEntityId());
        if (tracker == null) {
            if (NMSHandler.debugPackets) {
                DenizenNetworkManagerImpl.doPacketOutput("Failed to de-track entity " + entity.getEntityId() + " for " + player.getName() + ": tracker null");
            }
            return;
        }
        this.sendEntityDestroy(player, entity);
        tracker.a(nmsPlayer);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FakeEntity sendEntitySpawn(List<PlayerTag> players, DenizenEntityType entityType, LocationTag location, ArrayList<Mechanism> mechanisms, int customId, UUID customUUID, boolean autoTrack) {
        void var9_15;
        CraftWorld world = (CraftWorld)location.getWorld();
        if (entityType.isCustom()) {
            if (entityType.customEntityType == CustomEntityType.ITEM_PROJECTILE) {
                ItemStack itemStack = new ItemStack(Material.STONE);
                for (Mechanism mechanism : mechanisms) {
                    if (!mechanism.matches("item") || !mechanism.requireObject(ItemTag.class)) continue;
                    itemStack = ((ItemTag)mechanism.valueAsType(ItemTag.class)).getItemStack();
                }
                EntityItemProjectileImpl entityItemProjectileImpl = new EntityItemProjectileImpl((World)world.getHandle(), (Location)location, CraftItemStack.asNMSCopy((ItemStack)itemStack));
            } else {
                if (entityType.customEntityType != CustomEntityType.FAKE_PLAYER) throw new IllegalArgumentException("entityType");
                String name = null;
                Object skin = null;
                String blob = null;
                for (Mechanism mechanism : new ArrayList<Mechanism>(mechanisms)) {
                    if (mechanism.matches("name")) {
                        name = mechanism.getValue().asString();
                        mechanisms.remove(mechanism);
                    } else if (mechanism.matches("skin")) {
                        skin = mechanism.getValue().asString();
                        mechanisms.remove(mechanism);
                    } else if (mechanism.matches("skin_blob")) {
                        blob = mechanism.getValue().asString();
                        mechanisms.remove(mechanism);
                    }
                    if (name == null || skin == null && blob == null) continue;
                    break;
                }
                EntityPlayer entityPlayer = ((CraftFakePlayerImpl)NMSHandler.customEntityHelper.spawnFakePlayer((Location)location, name, skin, blob, false)).getHandle();
            }
        } else {
            bbn bbn2 = world.createEntity((Location)location, entityType.getBukkitEntityType().getEntityClass());
        }
        if (customUUID != null) {
            var9_15.e(customId);
            var9_15.a_(customUUID);
        }
        EntityTag entity = new EntityTag((Entity)var9_15.getBukkitEntity());
        entity.isFake = true;
        entity.isFakeValid = true;
        for (Mechanism mechanism : mechanisms) {
            entity.safeAdjustDuplicate(mechanism);
        }
        var9_15.dv();
        FakeEntity fake = new FakeEntity(players, location, entity.getBukkitEntity().getEntityId());
        fake.entity = new EntityTag(entity.getBukkitEntity());
        fake.entity.isFake = true;
        fake.entity.isFakeValid = true;
        ArrayList trackers = new ArrayList();
        fake.triggerSpawnPacket = arg_0 -> this.lambda$sendEntitySpawn$0(world, (bbn)var9_15, trackers, autoTrack, fake, arg_0);
        for (PlayerTag player : players) {
            fake.triggerSpawnPacket.accept(player);
        }
        fake.triggerUpdatePacket = () -> {
            for (TrackerData tracker : trackers) {
                if (!tracker.player.isOnline()) continue;
                tracker.tracker.a();
            }
        };
        fake.triggerDestroyPacket = () -> {
            for (TrackerData tracker : trackers) {
                if (!tracker.player.isOnline()) continue;
                tracker.tracker.a(((CraftPlayer)tracker.player.getPlayerEntity()).getHandle());
            }
            trackers.clear();
        };
        return fake;
    }

    public void sendEntityDestroy(Player player, Entity entity) {
        ((CraftPlayer)player).getHandle().b.a((tc)new PacketPlayOutEntityDestroy(new int[]{entity.getEntityId()}));
    }

    public int getFlyKickCooldown(Player player) {
        PlayerConnection conn = ((CraftPlayer)player).getHandle().b;
        if (conn instanceof AbstractListenerPlayInImpl) {
            conn = ((AbstractListenerPlayInImpl)conn).oldListener;
        }
        try {
            return Math.max(80 - Math.max(FLY_TICKS.getInt(conn), VEHICLE_FLY_TICKS.getInt(conn)), 0);
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
            return 80;
        }
    }

    public void setFlyKickCooldown(Player player, int ticks) {
        ticks = 80 - ticks;
        PlayerConnection conn = ((CraftPlayer)player).getHandle().b;
        if (conn instanceof AbstractListenerPlayInImpl) {
            conn = ((AbstractListenerPlayInImpl)conn).oldListener;
        }
        try {
            FLY_TICKS.setInt(conn, ticks);
            VEHICLE_FLY_TICKS.setInt(conn, ticks);
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
        }
    }

    public int ticksPassedDuringCooldown(Player player) {
        try {
            return ATTACK_COOLDOWN_TICKS.getInt(((CraftPlayer)player).getHandle());
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
            return -1;
        }
    }

    public float getMaxAttackCooldownTicks(Player player) {
        return ((CraftPlayer)player).getHandle().fU() + 3.0f;
    }

    public void setAttackCooldown(Player player, int ticks) {
        try {
            ATTACK_COOLDOWN_TICKS.setInt(((CraftPlayer)player).getHandle(), ticks);
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
        }
    }

    public boolean hasChunkLoaded(Player player, Chunk chunk) {
        return ((CraftWorld)chunk.getWorld()).getHandle().k().a.a(new ChunkCoordIntPair(chunk.getX(), chunk.getZ()), false).stream().anyMatch(entityPlayer -> entityPlayer.co().equals(player.getUniqueId()));
    }

    public void setTemporaryOp(Player player, boolean op) {
        afh server = ((CraftServer)Bukkit.getServer()).getServer();
        GameProfile profile = ((CraftPlayer)player).getProfile();
        OpList opList = server.ac().k();
        if (op) {
            int permLevel = server.h();
            opList.a((JsonListEntry)new OpListEntry(profile, permLevel, opList.a(profile)));
        } else {
            opList.c((Object)profile);
        }
        player.recalculatePermissions();
    }

    public void showEndCredits(Player player) {
        ((CraftPlayer)player).getHandle().f = true;
        ((CraftPlayer)player).getHandle().b.a((tc)new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.e, 1.0f));
    }

    public ImprovedOfflinePlayer getOfflineData(UUID uuid) {
        return new ImprovedOfflinePlayerImpl(uuid);
    }

    public ImprovedOfflinePlayer getOfflineData(OfflinePlayer offlinePlayer) {
        return new ImprovedOfflinePlayerImpl(offlinePlayer.getUniqueId());
    }

    public void resendRecipeDetails(Player player) {
        Collection recipes = ((CraftServer)Bukkit.getServer()).getServer().aE().b();
        PacketPlayOutRecipeUpdate updatePacket = new PacketPlayOutRecipeUpdate(recipes);
        ((CraftPlayer)player).getHandle().b.a((tc)updatePacket);
    }

    public void resendDiscoveredRecipes(Player player) {
        RecipeBookServer recipeBook = ((CraftPlayer)player).getHandle().E();
        recipeBook.a(((CraftPlayer)player).getHandle());
    }

    public void quietlyAddRecipe(Player player, NamespacedKey key) {
        RecipeBookServer recipeBook = ((CraftPlayer)player).getHandle().E();
        IRecipe<?> recipe = ItemHelperImpl.getNMSRecipe(key);
        if (recipe == null) {
            Debug.echoError((String)("Cannot add recipe '" + key + "': it does not exist."));
            return;
        }
        recipeBook.a(recipe);
        recipeBook.f(recipe);
    }

    public String getPlayerBrand(Player player) {
        return ((DenizenNetworkManagerImpl)((CraftPlayer)player).getHandle().b.b).packetListener.brand;
    }

    public byte getSkinLayers(Player player) {
        return (Byte)((CraftPlayer)player).getHandle().ai().a(ENTITY_HUMAN_SKINLAYERS_DATAWATCHER);
    }

    public void setSkinLayers(Player player, byte flags) {
        ((CraftPlayer)player).getHandle().ai().b(ENTITY_HUMAN_SKINLAYERS_DATAWATCHER, (Object)flags);
    }

    public void setBossBarTitle(BossBar bar, String title) {
        ((CraftBossBar)bar).getHandle().a = Handler.componentToNMS(FormattedTextHelper.parse((String)title, (ChatColor)ChatColor.WHITE));
        ((CraftBossBar)bar).getHandle().a(PacketPlayOutBoss::c);
    }

    public boolean getSpawnForced(Player player) {
        return ((CraftPlayer)player).getHandle().Q();
    }

    public void setSpawnForced(Player player, boolean forced) {
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        try {
            PLAYER_RESPAWNFORCED_SETTER.invoke(nmsPlayer, forced);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public long getLastActionTime(Player player) {
        return ((CraftPlayer)player).getHandle().I();
    }

    public void sendPlayerInfoAddPacket(Player player, PlayerHelper.ProfileEditMode mode, String name, String display, UUID id, String texture, String signature, int latency, GameMode gameMode) {
        PacketPlayOutPlayerInfo.EnumPlayerInfoAction action = mode == PlayerHelper.ProfileEditMode.ADD ? PacketPlayOutPlayerInfo.EnumPlayerInfoAction.a : (mode == PlayerHelper.ProfileEditMode.UPDATE_DISPLAY ? PacketPlayOutPlayerInfo.EnumPlayerInfoAction.d : PacketPlayOutPlayerInfo.EnumPlayerInfoAction.c);
        PacketPlayOutPlayerInfo packet = new PacketPlayOutPlayerInfo(action, new EntityPlayer[0]);
        GameProfile profile = new GameProfile(id, name);
        if (texture != null) {
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", texture, signature));
        }
        packet.b().add(new PacketPlayOutPlayerInfo.PlayerInfoData(profile, latency, EnumGamemode.a((String)CoreUtilities.toLowerCase((String)gameMode.name())), display == null ? null : Handler.componentToNMS(FormattedTextHelper.parse((String)display, (ChatColor)ChatColor.WHITE)), null));
        PacketHelperImpl.send(player, (tc)packet);
    }

    public void sendPlayerRemovePacket(Player player, UUID id) {
        PacketPlayOutPlayerInfo packet = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.e, new EntityPlayer[0]);
        GameProfile profile = new GameProfile(id, "name");
        packet.b().add(new PacketPlayOutPlayerInfo.PlayerInfoData(profile, 0, null, null, null));
        PacketHelperImpl.send(player, (tc)packet);
    }

    public void sendClimbableMaterials(Player player, List<Material> materials) {
        Map packetInput = alc.a((IRegistryCustom)((CraftServer)Bukkit.getServer()).getServer().aX());
        Map tags = (Map)ReflectionHelper.getFieldValue(alc.a.class, (String)ReflectionMappingsInfo.TagNetworkSerializationNetworkPayload_tags, packetInput.get(IRegistry.h));
        IntList intList = (IntList)tags.get(TagsBlock.aG.b());
        intList.clear();
        for (Material material : materials) {
            intList.add(IRegistry.V.a((Object)CraftMagicNumbers.getBlock((Material)material)));
        }
        PacketHelperImpl.send(player, (tc)new PacketPlayOutTags(packetInput));
    }

    private /* synthetic */ void lambda$sendEntitySpawn$0(CraftWorld world, bbn nmsEntity, List trackers, boolean autoTrack, final FakeEntity fake, final PlayerTag player) {
        EntityPlayer nmsPlayer = ((CraftPlayer)player.getPlayerEntity()).getHandle();
        PlayerConnection conn = nmsPlayer.b;
        final EntityTrackerEntry tracker = new EntityTrackerEntry(world.getHandle(), nmsEntity, 1, true, arg_0 -> ((PlayerConnection)conn).a(arg_0), Collections.singleton(nmsPlayer.b));
        tracker.b(nmsPlayer);
        TrackerData data = new TrackerData();
        data.player = player;
        data.tracker = tracker;
        trackers.add(data);
        if (autoTrack) {
            new BukkitRunnable(){
                boolean wasOnline = true;

                public void run() {
                    if (!fake.entity.isFakeValid) {
                        this.cancel();
                        return;
                    }
                    if (player.isOnline()) {
                        if (!this.wasOnline) {
                            tracker.b(((CraftPlayer)player.getPlayerEntity()).getHandle());
                            this.wasOnline = true;
                        }
                        tracker.a();
                    } else if (this.wasOnline) {
                        this.wasOnline = false;
                    }
                }
            }.runTaskTimer((Plugin)Denizen.getInstance(), 1L, 1L);
        }
    }

    static {
        DataWatcherObject skinlayers = null;
        try {
            skinlayers = (DataWatcherObject)ReflectionHelper.getFields(EntityHuman.class).get((Object)ReflectionMappingsInfo.Player_DATA_PLAYER_MODE_CUSTOMISATION).get(null);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        ENTITY_HUMAN_SKINLAYERS_DATAWATCHER = skinlayers;
    }

    public static class TrackerData {
        public PlayerTag player;
        public EntityTrackerEntry tracker;
    }
}

