/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.Location;
import org.bukkit.entity.EnderCrystal;

public class EntityBeamTarget
implements Property {
    public static final String[] handledMechs = new String[]{"beam_target"};
    EntityTag dentity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof EnderCrystal;
    }

    public static EntityBeamTarget getFrom(ObjectTag entity) {
        if (!EntityBeamTarget.describes(entity)) {
            return null;
        }
        return new EntityBeamTarget((EntityTag)entity);
    }

    private EntityBeamTarget(EntityTag entity) {
        this.dentity = entity;
    }

    @Override
    public String getPropertyString() {
        Location beamTarget = this.getCrystal().getBeamTarget();
        return beamTarget != null ? new LocationTag(beamTarget).identify() : null;
    }

    @Override
    public String getPropertyId() {
        return "beam_target";
    }

    public EnderCrystal getCrystal() {
        return (EnderCrystal)this.dentity.getBukkitEntity();
    }

    public static void register() {
        PropertyParser.registerTag(EntityBeamTarget.class, LocationTag.class, "beam_target", (attribute, object) -> {
            Location beamTarget = object.getCrystal().getBeamTarget();
            if (beamTarget != null) {
                return new LocationTag(beamTarget);
            }
            return null;
        }, new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("beam_target")) {
            if (mechanism.hasValue()) {
                if (mechanism.requireObject(LocationTag.class)) {
                    this.getCrystal().setBeamTarget((Location)mechanism.valueAsType(LocationTag.class));
                }
            } else {
                this.getCrystal().setBeamTarget(null);
            }
        }
    }
}

