/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.data.Snowable;

public class MaterialSnowable
implements Property {
    public static final String[] handledMechs = new String[]{"snowy"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && ((MaterialTag)material).getModernData() instanceof Snowable;
    }

    public static MaterialSnowable getFrom(ObjectTag _material) {
        if (!MaterialSnowable.describes(_material)) {
            return null;
        }
        return new MaterialSnowable((MaterialTag)_material);
    }

    private MaterialSnowable(MaterialTag _material) {
        this.material = _material;
    }

    public static void register() {
        PropertyParser.registerStaticTag(MaterialSnowable.class, ElementTag.class, "snowy", (attribute, material) -> new ElementTag(material.isSnowy()), new String[0]);
    }

    public Snowable getSnowable() {
        return (Snowable)this.material.getModernData();
    }

    public boolean isSnowy() {
        return this.getSnowable().isSnowy();
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.isSnowy());
    }

    @Override
    public String getPropertyId() {
        return "snowy";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("snowy") && mechanism.requireBoolean()) {
            this.getSnowable().setSnowy(mechanism.getValue().asBoolean());
        }
    }
}

