/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.destroystokyo.paper.event.inventory.PrepareResultEvent;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.GrindstoneInventory;

public class PlayerPreparesGrindstoneCraftScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PrepareResultEvent event;
    public PlayerTag player;

    public PlayerPreparesGrindstoneCraftScriptEvent() {
        this.registerCouldMatcher("player prepares grindstone craft <item>");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(4, new ItemTag(this.event.getResult()))) {
            return false;
        }
        if (!this.runInCheck(path, this.event.getInventory().getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String lower;
        if (determinationObj instanceof ElementTag && (lower = CoreUtilities.toLowerCase(determinationObj.toString())).startsWith("result:")) {
            ItemTag result = ItemTag.valueOf(lower.substring("result:".length()), path.container);
            this.event.setResult(result.getItemStack());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "inventory": {
                return InventoryTag.mirrorBukkitInventory(this.event.getInventory());
            }
            case "result": {
                return new ItemTag(this.event.getResult());
            }
        }
        return super.getContext(name);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @EventHandler
    public void onPlayerPreparesGrindstoneCraft(PrepareResultEvent event) {
        if (!(event.getInventory() instanceof GrindstoneInventory)) {
            return;
        }
        if (event.getViewers().isEmpty()) {
            return;
        }
        HumanEntity humanEntity = (HumanEntity)event.getViewers().get(0);
        if (EntityTag.isNPC((Entity)humanEntity)) {
            return;
        }
        this.player = EntityTag.getPlayerFrom((Entity)humanEntity);
        this.event = event;
        this.fire((Event)event);
    }
}

