/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class Conversion {
    public static List<Color> convertColors(List<ColorTag> colors) {
        ArrayList<Color> newList = new ArrayList<Color>();
        for (ColorTag color : colors) {
            newList.add(color.getColor());
        }
        return newList;
    }

    public static List<ItemStack> convertItems(List<ItemTag> items) {
        ArrayList<ItemStack> newList = new ArrayList<ItemStack>();
        for (ItemTag item : items) {
            newList.add(item.getItemStack());
        }
        return newList;
    }

    public static List<Entity> convertEntities(List<EntityTag> entities) {
        ArrayList<Entity> newList = new ArrayList<Entity>();
        for (EntityTag entity : entities) {
            newList.add(entity.getBukkitEntity());
        }
        return newList;
    }

    public static AbstractMap.SimpleEntry<Integer, InventoryTag> getInventory(Argument arg, ScriptEntry scriptEntry) {
        return Conversion.getInventory(arg, scriptEntry == null ? null : scriptEntry.context);
    }

    public static AbstractMap.SimpleEntry<Integer, InventoryTag> getInventory(Argument arg, TagContext context) {
        ListTag asList;
        InventoryTag inv;
        boolean isElement = arg.object instanceof ElementTag;
        if (arg.object instanceof InventoryTag || isElement && InventoryTag.matches(arg.getValue())) {
            InventoryTag inventoryTag = inv = arg.object instanceof InventoryTag ? (InventoryTag)arg.object : InventoryTag.valueOf(arg.getValue(), context);
            if (inv != null) {
                return new AbstractMap.SimpleEntry<Integer, InventoryTag>(inv.getContents().length, inv);
            }
        } else {
            if (arg.object instanceof MapTag || isElement && arg.getValue().startsWith("map@")) {
                MapTag map = arg.object instanceof MapTag ? (MapTag)arg.object : MapTag.valueOf(arg.getValue(), context);
                int maxSlot = 0;
                for (Map.Entry<StringHolder, ObjectTag> entry : map.map.entrySet()) {
                    if (!ArgumentHelper.matchesInteger(entry.getKey().str)) {
                        return null;
                    }
                    int n = new ElementTag(entry.getKey().str).asInt();
                    if (n <= maxSlot) continue;
                    maxSlot = n;
                }
                InventoryTag inventory = new InventoryTag(Math.min(54, maxSlot / 9 * 9 + 9));
                for (Map.Entry<StringHolder, ObjectTag> entry : map.map.entrySet()) {
                    int slot = new ElementTag(entry.getKey().str).asInt();
                    ItemTag item = ItemTag.getItemFor(entry.getValue(), context);
                    if (item == null) {
                        if (context != null && !context.debug && !CoreConfiguration.debugOverride) continue;
                        Debug.echoError("Not a valid item: '" + entry.getValue() + "'");
                        continue;
                    }
                    inventory.getInventory().setItem(slot - 1, item.getItemStack());
                }
                return new AbstractMap.SimpleEntry<Integer, InventoryTag>(maxSlot, inventory);
            }
            if (arg.object instanceof LocationTag || isElement && LocationTag.matches(arg.getValue()) ? (inv = (arg.object instanceof LocationTag ? (LocationTag)arg.object : LocationTag.valueOf(arg.getValue(), context)).getInventory()) != null : (arg.object instanceof EntityTag || arg.object instanceof PlayerTag || arg.object instanceof NPCTag || isElement && EntityTag.matches(arg.getValue())) && (inv = EntityTag.valueOf(arg.getValue(), context).getInventory()) != null) {
                return new AbstractMap.SimpleEntry<Integer, InventoryTag>(inv.getContents().length, inv);
            }
        }
        if ((asList = ListTag.getListFor(arg.object, context)).containsObjectsFrom(ItemTag.class) || asList.isEmpty()) {
            List<ItemTag> list = asList.filter(ItemTag.class, context);
            ItemStack[] items = Conversion.convertItems(list).toArray(new ItemStack[list.size()]);
            InventoryTag inventoryTag = new InventoryTag(Math.min(54, items.length / 9 * 9 + 9));
            inventoryTag.setContents(items);
            return new AbstractMap.SimpleEntry<Integer, InventoryTag>(items.length, inventoryTag);
        }
        return null;
    }
}

