/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.function.Consumer;

public class CommandExecutor {
    public static ScriptQueue currentQueue;

    public static void debugSingleExecution(ScriptEntry scriptEntry) {
        if (scriptEntry.getOriginalArguments().size() == 1 && scriptEntry.getOriginalArguments().get(0).equals("\u0000CALLBACK")) {
            return;
        }
        Consumer<String> altDebug = scriptEntry.getResidingQueue().debugOutput;
        scriptEntry.getResidingQueue().debugOutput = null;
        Debug.echoDebug(scriptEntry, Debug.DebugElement.Header, "<LP>Queue '" + scriptEntry.getResidingQueue().debugId + "<LP>' Executing: <G>(line " + scriptEntry.internal.lineNumber + ")<W> " + scriptEntry.internal.originalLine);
        scriptEntry.getResidingQueue().debugOutput = altDebug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execute(ScriptEntry scriptEntry) {
        if (scriptEntry.dbCallShouldDebug()) {
            CommandExecutor.debugSingleExecution(scriptEntry);
        }
        TagManager.recentTagError = false;
        AbstractCommand command = scriptEntry.internal.actualCommand;
        currentQueue = scriptEntry.getResidingQueue();
        if (CommandExecutor.currentQueue.procedural && !command.isProcedural) {
            Debug.echoError("Command " + command.name + " is not accepted within a procedure. Procedures may not produce a change in the world, they may only process logic.");
            return false;
        }
        String saveName = null;
        TagContext lastContext = Debug.currentContext;
        try {
            TagContext context;
            Debug.currentContext = context = scriptEntry.getContext();
            for (Argument arg : scriptEntry.internal.preprocArgs) {
                if (DenizenCore.implementation.handleCustomArgs(scriptEntry, arg)) continue;
                if (arg.matchesPrefix("if")) {
                    boolean shouldRun;
                    String tagged = CoreUtilities.toLowerCase(TagManager.tag(arg.getValue(), context));
                    boolean bl = shouldRun = tagged.equals("true") || tagged.equals("!false");
                    if (scriptEntry.dbCallShouldDebug()) {
                        Debug.echoDebug((Debuggable)scriptEntry, shouldRun ? "'if:' arg passed, command will run." : "'if:' arg returned false, command won't run.");
                    }
                    if (shouldRun) continue;
                    scriptEntry.setFinished(true);
                    currentQueue = null;
                    boolean bl2 = true;
                    return bl2;
                }
                if (!arg.matchesPrefix("save")) continue;
                saveName = TagManager.tag(arg.getValue(), context);
                if (!scriptEntry.dbCallShouldDebug()) continue;
                Debug.echoDebug((Debuggable)scriptEntry, "...remembering this script entry as '" + saveName + "'!");
            }
            if (command.generatedExecutor != null) {
                command.generatedExecutor.execute(scriptEntry);
            } else {
                command.parseArgs(scriptEntry);
                command.execute(scriptEntry);
            }
            if (saveName != null) {
                scriptEntry.getResidingQueue().holdScriptEntry(saveName, scriptEntry);
            }
            currentQueue = null;
            boolean bl = true;
            return bl;
        }
        catch (InvalidArgumentsException | InvalidArgumentsRuntimeException e) {
            if (e.getMessage() != null && e.getMessage().length() > 0) {
                Debug.echoError(scriptEntry, "Woah! Invalid arguments were specified!\n<FORCE_ALIGN>" + e.getMessage());
            } else {
                Debug.echoError(scriptEntry, "Woah! Invalid arguments were specified!");
            }
            Debug.log("Usage: " + command.getUsageHint());
            Debug.log("(Attempted: " + scriptEntry + ")");
            Debug.echoDebug((Debuggable)scriptEntry, Debug.DebugElement.Footer);
            scriptEntry.setFinished(true);
            currentQueue = null;
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            Debug.echoError(scriptEntry, "Woah! An exception has been called with this command!");
            Debug.echoError(scriptEntry, e);
            Debug.log("(Attempted: " + scriptEntry + ")");
            Debug.echoDebug((Debuggable)scriptEntry, Debug.DebugElement.Footer);
            scriptEntry.setFinished(true);
            currentQueue = null;
            boolean bl = false;
            return bl;
        }
        finally {
            Debug.currentContext = lastContext;
        }
    }
}

