/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public class DetermineCommand
extends AbstractCommand {
    public static String DETERMINE_NONE = "none";

    public DetermineCommand() {
        this.setName("determine");
        this.setSyntax("determine (passively) [<value>]");
        this.setRequiredArguments(1, 2);
        this.isProcedural = true;
        this.setBooleansHandled("passively", "passive");
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("outcome")) {
                scriptEntry.addObject("outcome", arg.hasPrefix() ? arg.getRawElement() : arg.object);
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("passively", new ElementTag(false));
        scriptEntry.defaultObject("outcome", new ElementTag(DETERMINE_NONE));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ObjectTag outcomeObj = (ObjectTag)scriptEntry.getObjectTag("outcome");
        boolean passively = scriptEntry.argAsBoolean("passively");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), outcomeObj, DetermineCommand.db("passively", passively), new QueueTag(scriptEntry.getResidingQueue()));
        }
        ScriptQueue queue = scriptEntry.getResidingQueue();
        ListTag determines = queue.determinations;
        if (determines == null) {
            queue.determinations = determines = new ListTag();
        }
        determines.addObject(outcomeObj);
        if (queue.determinationTarget != null) {
            queue.determinationTarget.applyDetermination(outcomeObj);
        }
        if (!passively) {
            scriptEntry.getResidingQueue().clear();
            scriptEntry.getResidingQueue().stop();
        }
    }
}

