/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;
import org.bukkit.event.entity.EntityDamageEvent;

public class HurtCommand
extends AbstractCommand {
    public HurtCommand() {
        this.setName("hurt");
        this.setSyntax("hurt (<#.#>) ({player}/<entity>|...) (cause:<cause>) (source:<entity>/<location>)");
        this.setRequiredArguments(0, 4);
        this.isProcedural = false;
        this.addRemappedPrefixes("source", "s");
        this.autoCompile();
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="source") @ArgPrefixed @ArgDefaultNull ObjectTag source, @ArgName(value="cause") @ArgPrefixed @ArgDefaultNull EntityDamageEvent.DamageCause cause, @ArgName(value="amount") @ArgLinear @ArgDefaultText(value="1") ObjectTag amountObj, @ArgName(value="entities") @ArgLinear @ArgDefaultNull ObjectTag entitiesObj) {
        List<EntityTag> entities;
        if (!amountObj.asElement().isDouble()) {
            ObjectTag swapEntities = entitiesObj;
            entitiesObj = amountObj;
            amountObj = swapEntities != null && swapEntities.asElement().isDouble() ? swapEntities : new ElementTag(1.0);
        }
        List<EntityTag> list = entities = entitiesObj == null ? null : entitiesObj.asType(ListTag.class, scriptEntry.context).filter(EntityTag.class, scriptEntry.context);
        if (entities == null && (entities = Utilities.entryDefaultEntityList(scriptEntry, true)) == null) {
            throw new InvalidArgumentsRuntimeException("No valid target entities found.");
        }
        EntityTag sourceEntity = null;
        LocationTag sourceLocation = null;
        if (source != null) {
            if (source.shouldBeType(LocationTag.class)) {
                sourceLocation = source.asType(LocationTag.class, scriptEntry.context);
            }
            if (source.shouldBeType(EntityTag.class)) {
                sourceEntity = source.asType(EntityTag.class, scriptEntry.context);
            }
        }
        double amount = amountObj.asElement().asDouble();
        for (EntityTag entity : entities) {
            if (entity.getLivingEntity() == null) {
                Debug.echoDebug((Debuggable)scriptEntry, entity + " is not a living entity!");
                continue;
            }
            NMSHandler.entityHelper.damage(entity.getLivingEntity(), (float)amount, sourceEntity, sourceLocation, cause);
        }
    }
}

