/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTagBuilder;
import com.denizenscript.denizen.nms.util.jnbt.FloatTag;
import com.denizenscript.denizen.nms.util.jnbt.JNBTListTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemArmorPose
implements Property {
    public static final String[] handledMechs = new String[]{"armor_pose"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getBukkitMaterial() == Material.ARMOR_STAND;
    }

    public static ItemArmorPose getFrom(ObjectTag item) {
        if (!ItemArmorPose.describes(item)) {
            return null;
        }
        return new ItemArmorPose((ItemTag)item);
    }

    private ItemArmorPose(ItemTag item) {
        this.item = item;
    }

    public static void procPart(CompoundTag pose, String nmsName, String denizenName, MapTag result) {
        List<Tag> list = pose.getList(nmsName);
        if (list == null || list.size() != 3) {
            return;
        }
        Tag x = list.get(0);
        Tag y = list.get(1);
        Tag z = list.get(2);
        if (!(x instanceof FloatTag && y instanceof FloatTag && z instanceof FloatTag)) {
            return;
        }
        String combined = x.getValue() + "," + y.getValue() + "," + z.getValue();
        result.putObject(denizenName, new ElementTag(combined));
    }

    public MapTag getPoseMap() {
        CompoundTag compoundTag = NMSHandler.itemHelper.getNbtData(this.item.getItemStack());
        if (compoundTag == null) {
            return null;
        }
        Tag entPart = (Tag)compoundTag.getValue().get("EntityTag");
        if (!(entPart instanceof CompoundTag)) {
            return null;
        }
        Tag posePart = (Tag)((CompoundTag)entPart).getValue().get("Pose");
        if (!(posePart instanceof CompoundTag)) {
            return null;
        }
        CompoundTag pose = (CompoundTag)posePart;
        MapTag result = new MapTag();
        ItemArmorPose.procPart(pose, "Head", "head", result);
        ItemArmorPose.procPart(pose, "Body", "body", result);
        ItemArmorPose.procPart(pose, "LeftArm", "left_arm", result);
        ItemArmorPose.procPart(pose, "RightArm", "right_arm", result);
        ItemArmorPose.procPart(pose, "LeftLeg", "left_leg", result);
        ItemArmorPose.procPart(pose, "RightLeg", "right_leg", result);
        return result;
    }

    public static void register() {
        PropertyParser.registerTag(ItemArmorPose.class, MapTag.class, "armor_pose", (attribute, item) -> item.getPoseMap(), new String[0]);
    }

    @Override
    public String getPropertyString() {
        MapTag result = this.getPoseMap();
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    @Override
    public String getPropertyId() {
        return "armor_pose";
    }

    public static void procMechKey(Mechanism mech, CompoundTagBuilder pose, String nmsName, String denizenName, MapTag input) {
        ObjectTag value = input.getObject(denizenName);
        if (value == null) {
            return;
        }
        List<String> raw = CoreUtilities.split(value.toString(), ',');
        if (raw.size() != 3) {
            mech.echoError("Invalid pose piece '" + value + "'");
            return;
        }
        ArrayList<FloatTag> rawList = new ArrayList<FloatTag>();
        for (int i = 0; i < 3; ++i) {
            rawList.add(new FloatTag(Float.parseFloat(raw.get(i))));
        }
        JNBTListTag list = new JNBTListTag(FloatTag.class, rawList);
        pose.put(nmsName, list);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("armor_pose")) {
            Tag entPart;
            CompoundTag compoundTag = NMSHandler.itemHelper.getNbtData(this.item.getItemStack());
            if (mechanism.hasValue() && mechanism.requireObject(MapTag.class)) {
                if (compoundTag == null) {
                    compoundTag = new CompoundTagBuilder().build();
                }
                if (!((entPart = (Tag)compoundTag.getValue().get("EntityTag")) instanceof CompoundTag)) {
                    entPart = new CompoundTagBuilder().build();
                }
                CompoundTagBuilder poseBuilder = new CompoundTagBuilder();
                MapTag input = mechanism.valueAsType(MapTag.class);
                ItemArmorPose.procMechKey(mechanism, poseBuilder, "Head", "head", input);
                ItemArmorPose.procMechKey(mechanism, poseBuilder, "Body", "body", input);
                ItemArmorPose.procMechKey(mechanism, poseBuilder, "LeftArm", "left_arm", input);
                ItemArmorPose.procMechKey(mechanism, poseBuilder, "RightArm", "right_arm", input);
                ItemArmorPose.procMechKey(mechanism, poseBuilder, "LeftLeg", "left_leg", input);
                ItemArmorPose.procMechKey(mechanism, poseBuilder, "RightLeg", "right_leg", input);
                CompoundTag pose = poseBuilder.build();
                entPart = pose.getValue().isEmpty() ? ((CompoundTag)entPart).createBuilder().remove("Pose").build() : ((CompoundTag)entPart).createBuilder().put("Pose", pose).build();
            } else {
                if (compoundTag == null) {
                    return;
                }
                entPart = (Tag)compoundTag.getValue().get("EntityTag");
                if (!(entPart instanceof CompoundTag)) {
                    return;
                }
                Tag posePart = (Tag)((CompoundTag)entPart).getValue().get("Pose");
                if (!(posePart instanceof CompoundTag)) {
                    return;
                }
                entPart = ((CompoundTag)entPart).createBuilder().remove("Pose").build();
            }
            compoundTag = ((CompoundTag)entPart).getValue().isEmpty() ? compoundTag.createBuilder().remove("EntityTag").build() : compoundTag.createBuilder().put("EntityTag", entPart).build();
            ItemStack result = NMSHandler.itemHelper.setNbtData(this.item.getItemStack(), compoundTag);
            this.item.setItemStack(result);
        }
    }
}

