/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.properties;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityFormObject;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Goat;

public class PaperEntityProperties
implements Property {
    public static final String[] handledMechs = new String[]{"goat_ram"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag;
    }

    public static PaperEntityProperties getFrom(ObjectTag entity) {
        if (!PaperEntityProperties.describes(entity)) {
            return null;
        }
        return new PaperEntityProperties((EntityTag)entity);
    }

    private PaperEntityProperties(EntityTag entity) {
        this.entity = entity;
    }

    @Override
    public String getPropertyString() {
        return null;
    }

    @Override
    public String getPropertyId() {
        return "EntityPaperProperties";
    }

    public static void register() {
        PropertyParser.registerTag(PaperEntityProperties.class, ElementTag.class, "spawn_reason", (attribute, entity) -> new ElementTag((Enum<?>)entity.entity.getBukkitEntity().getEntitySpawnReason()), new String[0]);
        PropertyParser.registerTag(PaperEntityProperties.class, ElementTag.class, "xp_spawn_reason", (attribute, entity) -> {
            if (!(entity.entity.getBukkitEntity() instanceof ExperienceOrb)) {
                attribute.echoError("Entity " + entity.entity + " is not an experience orb.");
                return null;
            }
            return new ElementTag((Enum<?>)((ExperienceOrb)entity.entity.getBukkitEntity()).getSpawnReason());
        }, new String[0]);
        PropertyParser.registerTag(PaperEntityProperties.class, EntityFormObject.class, "xp_trigger", (attribute, entity) -> {
            if (!(entity.entity.getBukkitEntity() instanceof ExperienceOrb)) {
                attribute.echoError("Entity " + entity.entity + " is not an experience orb.");
                return null;
            }
            UUID uuid = ((ExperienceOrb)entity.entity.getBukkitEntity()).getTriggerEntityId();
            if (uuid == null) {
                return null;
            }
            Entity e2 = EntityTag.getEntityForID(uuid);
            if (e2 == null) {
                return null;
            }
            return new EntityTag(e2).getDenizenObject();
        }, new String[0]);
        PropertyParser.registerTag(PaperEntityProperties.class, EntityFormObject.class, "xp_source", (attribute, entity) -> {
            if (!(entity.entity.getBukkitEntity() instanceof ExperienceOrb)) {
                attribute.echoError("Entity " + entity.entity + " is not an experience orb.");
                return null;
            }
            UUID uuid = ((ExperienceOrb)entity.entity.getBukkitEntity()).getSourceEntityId();
            if (uuid == null) {
                return null;
            }
            Entity e2 = EntityTag.getEntityForID(uuid);
            if (e2 == null) {
                return null;
            }
            return new EntityTag(e2).getDenizenObject();
        }, new String[0]);
        PropertyParser.registerTag(PaperEntityProperties.class, LocationTag.class, "spawn_location", (attribute, entity) -> {
            Location loc = entity.entity.getBukkitEntity().getOrigin();
            return loc != null ? new LocationTag(loc) : null;
        }, new String[0]);
        PropertyParser.registerTag(PaperEntityProperties.class, ElementTag.class, "from_spawner", (attribute, entity) -> new ElementTag(entity.entity.getBukkitEntity().fromMobSpawner()), new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("goat_ram") && mechanism.requireObject(EntityTag.class) && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17) && this.entity.getBukkitEntity() instanceof Goat) {
            ((Goat)this.entity.getBukkitEntity()).ram(mechanism.valueAsType(EntityTag.class).getLivingEntity());
        }
    }
}

