/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.midi;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.midi.MidiUtil;
import com.denizenscript.denizen.utilities.midi.ToneUtil;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class NoteBlockReceiver
implements Receiver,
MetaEventListener {
    public float VOLUME_RANGE = 10.0f;
    private List<EntityTag> entities;
    private LocationTag location;
    private Map<Integer, Integer> channelPatches;
    public String key;
    public Sequencer sequencer;
    public boolean closing = false;
    public Runnable onFinish = null;
    private static final int[] instruments_1_12 = new int[]{0, 0, 0, 0, 0, 0, 0, 5, 9, 9, 9, 9, 9, 6, 0, 9, 9, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 1, 1, 1, 1, 1, 1, 1, 1, 5, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 9, 8, 5, 8, 6, 6, 3, 3, 2, 2, 2, 6, 5, 1, 1, 1, 6, 1, 2, 4, 7};
    public static final Sound defaultMidiInstrument = Sound.BLOCK_NOTE_BLOCK_HARP;

    public NoteBlockReceiver(List<EntityTag> entities, String _Key) {
        this.entities = entities;
        this.location = null;
        this.channelPatches = Maps.newHashMap();
        this.key = _Key;
    }

    public NoteBlockReceiver(LocationTag location, String _Key) {
        this.entities = null;
        this.location = location;
        this.channelPatches = Maps.newHashMap();
        this.key = _Key;
    }

    public void setSequencer(Sequencer sequencer) {
        this.sequencer = sequencer;
    }

    @Override
    public void meta(MetaMessage meta) {
        if (meta.getType() == 47) {
            this.close();
        }
    }

    @Override
    public void send(MidiMessage m, long time) {
        if (this.closing) {
            return;
        }
        if (m instanceof ShortMessage) {
            ShortMessage smessage = (ShortMessage)m;
            int chan = smessage.getChannel();
            switch (smessage.getCommand()) {
                case 192: {
                    int patch = smessage.getData1();
                    this.channelPatches.put(chan, patch);
                    break;
                }
                case 144: {
                    this.playNote(smessage);
                    break;
                }
                case 128: {
                    break;
                }
                case 252: {
                    this.close();
                }
            }
        }
    }

    public void playNote(ShortMessage message) {
        int channel = message.getChannel();
        if (channel == 9) {
            return;
        }
        if (this.channelPatches == null) {
            Debug.echoError("Trying to play notes on closed midi NoteBlockReceiver!");
            return;
        }
        Integer patch = this.channelPatches.get(channel);
        float pitch = (float)ToneUtil.midiToPitch(message);
        float volume = this.VOLUME_RANGE * ((float)message.getData2() / 127.0f);
        Sound instrument = patch == null ? defaultMidiInstrument : NoteBlockReceiver.getMidiInstrumentFromPatch(patch);
        Runnable actualPlay = () -> {
            if (this.location != null) {
                this.location.getWorld().playSound((Location)this.location, instrument, volume, pitch);
            } else if (this.entities != null && !this.entities.isEmpty()) {
                for (int i = 0; i < this.entities.size(); ++i) {
                    EntityTag entity = this.entities.get(i);
                    if (entity.isSpawned()) {
                        if (entity.isPlayer()) {
                            entity.getPlayer().playSound((Entity)entity.getPlayer(), instrument, SoundCategory.RECORDS, volume, pitch);
                            continue;
                        }
                        entity.getLocation().getWorld().playSound((Location)entity.getLocation(), instrument, SoundCategory.RECORDS, volume, pitch);
                        continue;
                    }
                    this.entities.remove(i);
                    --i;
                }
            } else {
                this.close();
            }
        };
        if (Bukkit.isPrimaryThread()) {
            actualPlay.run();
        } else {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.getInstance(), actualPlay);
        }
    }

    @Override
    public void close() {
        if (this.closing) {
            return;
        }
        this.closing = true;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.getInstance(), () -> {
            try {
                MidiUtil.receivers.remove(this.key);
                if (this.sequencer != null) {
                    this.sequencer.close();
                    this.sequencer = null;
                }
                this.channelPatches.clear();
                this.channelPatches = null;
                this.entities = null;
                this.location = null;
                if (this.onFinish != null) {
                    this.onFinish.run();
                }
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
        }, 1L);
    }

    public static Sound getMidiInstrumentFromPatch(int patch) {
        switch (instruments_1_12[patch]) {
            case 0: {
                return Sound.BLOCK_NOTE_BLOCK_HARP;
            }
            case 1: {
                return Sound.BLOCK_NOTE_BLOCK_BASS;
            }
            case 2: {
                return Sound.BLOCK_NOTE_BLOCK_SNARE;
            }
            case 3: {
                return Sound.BLOCK_NOTE_BLOCK_HAT;
            }
            case 4: {
                return Sound.BLOCK_NOTE_BLOCK_BASEDRUM;
            }
            case 5: {
                return Sound.BLOCK_NOTE_BLOCK_GUITAR;
            }
            case 6: {
                return Sound.BLOCK_NOTE_BLOCK_BELL;
            }
            case 7: {
                return Sound.BLOCK_NOTE_BLOCK_CHIME;
            }
            case 8: {
                return Sound.BLOCK_NOTE_BLOCK_FLUTE;
            }
            case 9: {
                return Sound.BLOCK_NOTE_BLOCK_XYLOPHONE;
            }
            case 10: {
                return Sound.BLOCK_NOTE_BLOCK_PLING;
            }
        }
        return defaultMidiInstrument;
    }
}

