/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.tags.TagContext;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.inventory.Inventory;

public class PlayerSmithsItemScriptEvent
extends BukkitScriptEvent
implements Listener {
    public SmithItemEvent event;
    public ItemTag result;
    public PlayerTag player;

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventLower.startsWith("player smiths")) {
            return false;
        }
        return PlayerSmithsItemScriptEvent.couldMatchItem(path.eventArgLowerAt(2));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(2, this.result)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (ItemTag.matches(determination)) {
            this.result = determinationObj.asType(ItemTag.class, (TagContext)this.getTagContext(path));
            this.event.getInventory().setResult(this.result.getItemStack());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("item")) {
            return this.result;
        }
        if (name.equals("inventory")) {
            return InventoryTag.mirrorBukkitInventory((Inventory)this.event.getInventory());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onCraftItem(SmithItemEvent event) {
        HumanEntity humanEntity = event.getView().getPlayer();
        if (EntityTag.isNPC((Entity)humanEntity)) {
            return;
        }
        this.event = event;
        this.result = new ItemTag(event.getInventory().getResult());
        this.player = EntityTag.getPlayerFrom((Entity)humanEntity);
        this.cancelled = false;
        this.fire((Event)event);
    }
}

