/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;

public class EntityMaterial
implements Property {
    public static final String[] handledMechs = new String[]{"material"};
    EntityTag entity;

    public static boolean describes(ObjectTag object) {
        if (!(object instanceof EntityTag)) {
            return false;
        }
        Entity entity = ((EntityTag)object).getBukkitEntity();
        return entity instanceof Enderman || entity instanceof Minecart;
    }

    public static EntityMaterial getFrom(ObjectTag _entity) {
        if (!EntityMaterial.describes(_entity)) {
            return null;
        }
        return new EntityMaterial((EntityTag)_entity);
    }

    private EntityMaterial(EntityTag _entity) {
        this.entity = _entity;
    }

    public static void register() {
        PropertyParser.registerTag(EntityMaterial.class, MaterialTag.class, "material", (attribute, object) -> object.getMaterial(), new String[0]);
    }

    public boolean isEnderman() {
        return this.entity.getBukkitEntity() instanceof Enderman;
    }

    public boolean isMinecart() {
        return this.entity.getBukkitEntity() instanceof Minecart;
    }

    public Enderman getEnderman() {
        return (Enderman)this.entity.getBukkitEntity();
    }

    public Minecart getMinecart() {
        return (Minecart)this.entity.getBukkitEntity();
    }

    public MaterialTag getMaterial() {
        BlockData data = null;
        if (this.isEnderman()) {
            data = this.getEnderman().getCarriedBlock();
        } else if (this.isMinecart()) {
            data = this.getMinecart().getDisplayBlockData();
        }
        if (data == null) {
            return new MaterialTag(Material.AIR);
        }
        return new MaterialTag(data);
    }

    @Override
    public String getPropertyString() {
        MaterialTag material = this.getMaterial();
        if (material.getMaterial() != Material.AIR) {
            return material.identify();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "material";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("material") && mechanism.requireObject(MaterialTag.class)) {
            BlockData data = mechanism.valueAsType(MaterialTag.class).getModernData();
            if (this.isEnderman()) {
                this.getEnderman().setCarriedBlock(data);
            } else if (this.isMinecart()) {
                this.getMinecart().setDisplayBlockData(data);
            }
        }
    }
}

