/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Candle;
import org.bukkit.block.data.type.RespawnAnchor;
import org.bukkit.block.data.type.SeaPickle;
import org.bukkit.block.data.type.TurtleEgg;

public class MaterialCount
implements Property {
    public static final String[] handledMechs = new String[]{"count", "pickle_count"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        if (!(material instanceof MaterialTag)) {
            return false;
        }
        MaterialTag mat = (MaterialTag)material;
        if (!mat.hasModernData()) {
            return false;
        }
        BlockData data = mat.getModernData();
        return data instanceof SeaPickle || data instanceof TurtleEgg || data instanceof RespawnAnchor || data instanceof Candle;
    }

    public static MaterialCount getFrom(ObjectTag _material) {
        if (!MaterialCount.describes(_material)) {
            return null;
        }
        return new MaterialCount((MaterialTag)_material);
    }

    private MaterialCount(MaterialTag _material) {
        this.material = _material;
    }

    public static void register() {
        PropertyParser.registerStaticTag(MaterialCount.class, ElementTag.class, "count", (attribute, material) -> new ElementTag(material.getCurrent()), "pickle_count");
        PropertyParser.registerStaticTag(MaterialCount.class, ElementTag.class, "count_max", (attribute, material) -> new ElementTag(material.getMax()), "pickle_max");
        PropertyParser.registerStaticTag(MaterialCount.class, ElementTag.class, "count_min", (attribute, material) -> new ElementTag(material.getMin()), "pickle_min");
    }

    public boolean isSeaPickle() {
        return this.material.getModernData() instanceof SeaPickle;
    }

    public boolean isTurtleEgg() {
        return this.material.getModernData() instanceof TurtleEgg;
    }

    public boolean isRespawnAnchor() {
        return this.material.getModernData() instanceof RespawnAnchor;
    }

    public boolean isCandle() {
        return this.material.getModernData() instanceof Candle;
    }

    public TurtleEgg getTurtleEgg() {
        return (TurtleEgg)this.material.getModernData();
    }

    public SeaPickle getSeaPickle() {
        return (SeaPickle)this.material.getModernData();
    }

    public RespawnAnchor getRespawnAnchor() {
        return (RespawnAnchor)this.material.getModernData();
    }

    public Candle getCandle() {
        return (Candle)this.material.getModernData();
    }

    public int getCurrent() {
        if (this.isSeaPickle()) {
            return this.getSeaPickle().getPickles();
        }
        if (this.isTurtleEgg()) {
            return this.getTurtleEgg().getEggs();
        }
        if (this.isRespawnAnchor()) {
            return this.getRespawnAnchor().getCharges();
        }
        if (this.isCandle()) {
            return this.getCandle().getCandles();
        }
        throw new UnsupportedOperationException();
    }

    public int getMax() {
        if (this.isSeaPickle()) {
            return this.getSeaPickle().getMaximumPickles();
        }
        if (this.isTurtleEgg()) {
            return this.getTurtleEgg().getMaximumEggs();
        }
        if (this.isRespawnAnchor()) {
            return this.getRespawnAnchor().getMaximumCharges();
        }
        if (this.isCandle()) {
            return this.getCandle().getMaximumCandles();
        }
        throw new UnsupportedOperationException();
    }

    public int getMin() {
        if (this.isSeaPickle()) {
            return this.getSeaPickle().getMinimumPickles();
        }
        if (this.isTurtleEgg()) {
            return this.getTurtleEgg().getMinimumEggs();
        }
        if (this.isRespawnAnchor()) {
            return 0;
        }
        if (this.isCandle()) {
            return 1;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.getCurrent());
    }

    @Override
    public String getPropertyId() {
        return "count";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if ((mechanism.matches("count") || mechanism.matches("pickle_count")) && mechanism.requireInteger()) {
            int count = mechanism.getValue().asInt();
            if (count < this.getMin() || count > this.getMax()) {
                mechanism.echoError("Material count mechanism value '" + count + "' is not valid. Must be between " + this.getMin() + " and " + this.getMax() + ".");
                return;
            }
            if (this.isSeaPickle()) {
                this.getSeaPickle().setPickles(count);
            } else if (this.isTurtleEgg()) {
                this.getTurtleEgg().setEggs(count);
            } else if (this.isRespawnAnchor()) {
                this.getRespawnAnchor().setCharges(count);
            } else if (this.isCandle()) {
                this.getCandle().setCandles(count);
            }
        }
    }
}

