/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.properties;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import java.util.Collection;
import org.bukkit.Material;

public class PaperPlayerExtensions {
    public static void register() {
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, "affects_monster_spawning", (attribute, object) -> new ElementTag(object.getPlayerEntity().getAffectsSpawning()), new String[0]);
        PlayerTag.registerOnlineOnlyMechanism("affects_monster_spawning", ElementTag.class, (object, mechanism, input) -> {
            if (mechanism.requireBoolean()) {
                object.getPlayerEntity().setAffectsSpawning(input.asBoolean());
            }
        });
        PlayerTag.registerOnlineOnlyMechanism("firework_boost", ItemTag.class, (object, mechanism, input) -> {
            if (!object.getPlayerEntity().isGliding()) {
                mechanism.echoError("Cannot adjust 'firework_boost': player must be gliding.");
                return;
            }
            if (input.getBukkitMaterial() != Material.FIREWORK_ROCKET) {
                mechanism.echoError("Invalid input item '" + input + "': must be a firework rocket.");
                return;
            }
            object.getPlayerEntity().boostElytra(input.getItemStack());
        });
        PlayerTag.registerOnlineOnlyMechanism("fake_op_level", ElementTag.class, (object, mechanism, input) -> {
            if (mechanism.requireInteger()) {
                object.getPlayerEntity().sendOpLevel((byte)input.asInt());
            }
        });
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19)) {
            PlayerTag.registerOnlineOnlyMechanism("add_tab_completions", ListTag.class, (object, mechanism, input) -> object.getPlayerEntity().addAdditionalChatCompletions((Collection)((Object)input)));
            PlayerTag.registerOnlineOnlyMechanism("remove_tab_completions", ListTag.class, (object, mechanism, input) -> object.getPlayerEntity().removeAdditionalChatCompletions((Collection)((Object)input)));
        }
    }
}

