/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.AreaContainmentObject;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.blocks.BlockSet;
import com.denizenscript.denizen.utilities.blocks.CuboidBlockSet;
import com.denizenscript.denizen.utilities.blocks.FullBlockData;
import com.denizenscript.denizen.utilities.blocks.SpongeSchematicHelper;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.plugin.Plugin;

public class SchematicCommand
extends AbstractCommand
implements Holdable,
Listener {
    public static boolean noPhys = false;
    public static Map<String, CuboidBlockSet> schematics;

    public SchematicCommand() {
        this.setName("schematic");
        this.setSyntax("schematic [create/load/unload/rotate/save/flip_x/flip_y/flip_z/paste (fake_to:<player>|... fake_duration:<duration>) (noair) (mask:<material_matcher>)] [name:<name>] (filename:<name>) (angle:<#>) (<location>) (area:<area>) (delayed) (max_delay_ms:<#>) (entities) (flags)");
        this.setRequiredArguments(2, 13);
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                SchematicCommand.this.schematicTags(event);
            }
        }, "schematic");
        schematics = new HashMap<String, CuboidBlockSet>();
        noPhys = false;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Denizen.getInstance());
        this.isProcedural = false;
        this.setBooleansHandled("noair", "delayed", "entities", "flags");
        this.setPrefixesHandled("angle", "fake_duration", "mask", "name", "filename", "max_delay_ms", "fake_to", "area");
    }

    @EventHandler
    public void onBlockPhysics(BlockPhysicsEvent event) {
        if (noPhys) {
            event.setCancelled(true);
        }
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.addWithPrefix("name:", schematics.keySet());
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("type") && arg.matchesEnum(Type.class)) {
                scriptEntry.addObject("type", new ElementTag(arg.getRawValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class).getBlockLocation());
                continue;
            }
            if (!scriptEntry.hasObject("area") && arg.matchesArgumentType(CuboidTag.class)) {
                scriptEntry.addObject("area", arg.asType(CuboidTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("type")) {
            throw new InvalidArgumentsException("Missing type argument!");
        }
    }

    public static void rotateSchem(CuboidBlockSet schematic, int angle, boolean delayed, Runnable callback) {
        Runnable rotateRunnable = () -> {
            try {
                int ang;
                for (ang = angle; ang < 0; ang = 360 + ang) {
                }
                while (ang >= 360) {
                    ang -= 360;
                }
                if (ang != 0) {
                    for (ang = 360 - ang; ang > 0; ang -= 90) {
                        schematic.rotateOne();
                    }
                }
            }
            finally {
                if (delayed) {
                    Bukkit.getScheduler().runTask((Plugin)Denizen.instance, () -> {
                        schematic.isModifying = false;
                    });
                }
                if (callback != null) {
                    if (delayed) {
                        Bukkit.getScheduler().runTask((Plugin)Denizen.instance, callback);
                    } else {
                        callback.run();
                    }
                }
            }
        };
        if (delayed) {
            schematic.isModifying = true;
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Denizen.instance, rotateRunnable);
        } else {
            rotateRunnable.run();
        }
    }

    public static void parseMask(ScriptEntry scriptEntry, String maskText, HashSet<Material> mask) {
        if (maskText.startsWith("li@")) {
            for (MaterialTag material : ListTag.valueOf(maskText, scriptEntry.getContext()).filter(MaterialTag.class, scriptEntry)) {
                mask.add(material.getMaterial());
            }
        } else {
            for (Material material : Material.values()) {
                if (!MaterialTag.advancedMatchesInternal(material, maskText, true)) continue;
                mask.add(material);
            }
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag angle = scriptEntry.argForPrefixAsElement("angle", null);
        ElementTag type = scriptEntry.getElement("type");
        ElementTag name = scriptEntry.requiredArgForPrefixAsElement("name");
        ElementTag filename = scriptEntry.argForPrefixAsElement("filename", null);
        boolean noair = scriptEntry.argAsBoolean("noair");
        boolean delayed = scriptEntry.argAsBoolean("delayed") || scriptEntry.shouldWaitFor();
        ElementTag maxDelayMs = scriptEntry.argForPrefixAsElement("max_delay_ms", "50");
        boolean copyEntities = scriptEntry.argAsBoolean("entities");
        boolean flags = scriptEntry.argAsBoolean("flags");
        LocationTag location = (LocationTag)scriptEntry.getObjectTag("location");
        ElementTag mask = scriptEntry.argForPrefixAsElement("mask", null);
        List<PlayerTag> fakeTo = scriptEntry.argForPrefixList("fake_to", PlayerTag.class, true);
        DurationTag fakeDuration = scriptEntry.argForPrefix("fake_duration", DurationTag.class, true);
        CuboidTag legacyCuboid = (CuboidTag)scriptEntry.getObjectTag("area");
        AreaContainmentObject areaVal = null;
        if (legacyCuboid != null) {
            areaVal = legacyCuboid;
        } else {
            Argument areaArg = scriptEntry.argForPrefix("area");
            if (areaArg != null) {
                if (areaArg.object instanceof AreaContainmentObject) {
                    areaVal = (AreaContainmentObject)areaArg.object;
                } else {
                    ObjectTag reparsedArea = ObjectFetcher.pickObjectFor(areaArg.getValue(), scriptEntry.context);
                    if (reparsedArea instanceof AreaContainmentObject) {
                        areaVal = (AreaContainmentObject)reparsedArea;
                    } else {
                        throw new InvalidArgumentsRuntimeException("Area input '" + areaArg.getValue() + "' is not a valid Area object");
                    }
                }
            }
        }
        CuboidTag area = areaVal;
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), type, name, location, filename, area, angle, SchematicCommand.db("noair", noair), SchematicCommand.db("delayed", delayed), maxDelayMs, SchematicCommand.db("flags", flags), SchematicCommand.db("entities", copyEntities), mask, fakeDuration, SchematicCommand.db("fake_to", fakeTo));
        }
        Type ttype = Type.valueOf(type.asString());
        String fname = filename != null ? filename.asString() : name.asString();
        switch (ttype) {
            case CREATE: {
                CuboidBlockSet set;
                if (schematics.containsKey(name.asString().toUpperCase())) {
                    Debug.echoError(scriptEntry, "Schematic file " + name.asString() + " is already loaded.");
                    scriptEntry.setFinished(true);
                    return;
                }
                if (area == null) {
                    Debug.echoError(scriptEntry, "Missing area argument!");
                    scriptEntry.setFinished(true);
                    return;
                }
                if (location == null) {
                    Debug.echoError(scriptEntry, "Missing origin location argument!");
                    scriptEntry.setFinished(true);
                    return;
                }
                try {
                    HashSet<Material> maskSet = null;
                    if (mask != null) {
                        String maskText = mask.asString();
                        maskSet = new HashSet<Material>();
                        SchematicCommand.parseMask(scriptEntry, maskText, maskSet);
                    }
                    set = new CuboidBlockSet();
                    if (delayed) {
                        set.buildDelayed(area, location, maskSet, () -> {
                            if (copyEntities) {
                                set.buildEntities(area, location);
                            }
                            schematics.put(name.asString().toUpperCase(), set);
                            scriptEntry.setFinished(true);
                        }, maxDelayMs.asLong(), flags);
                        break;
                    }
                    scriptEntry.setFinished(true);
                    set.buildImmediate(area, location, maskSet, flags);
                    if (copyEntities) {
                        set.buildEntities(area, location);
                    }
                    schematics.put(name.asString().toUpperCase(), set);
                    break;
                }
                catch (Exception ex) {
                    Debug.echoError(scriptEntry, "Error creating schematic object " + name.asString() + ".");
                    Debug.echoError(scriptEntry, ex);
                    scriptEntry.setFinished(true);
                    return;
                }
            }
            case LOAD: {
                if (schematics.containsKey(name.asString().toUpperCase())) {
                    Debug.echoError(scriptEntry, "Schematic file " + name.asString() + " is already loaded.");
                    scriptEntry.setFinished(true);
                    return;
                }
                String directory = URLDecoder.decode(System.getProperty("user.dir"));
                File f = new File(directory + "/plugins/Denizen/schematics/" + fname + ".schem");
                if (!Utilities.canReadFile(f)) {
                    Debug.echoError("Cannot read from that file path due to security settings in Denizen/config.yml.");
                    scriptEntry.setFinished(true);
                    return;
                }
                if (!f.exists() && !(f = new File(directory + "/plugins/Denizen/schematics/" + fname + ".schematic")).exists()) {
                    Debug.echoError("Schematic file " + fname + " does not exist. Are you sure it's in " + directory + "/plugins/Denizen/schematics/?");
                    scriptEntry.setFinished(true);
                    return;
                }
                File schemFile = f;
                Runnable loadRunnable = () -> {
                    try {
                        FileInputStream fs = new FileInputStream(schemFile);
                        CuboidBlockSet newSet = SpongeSchematicHelper.fromSpongeStream(fs);
                        ((InputStream)fs).close();
                        Runnable storeSchem = () -> {
                            schematics.put(name.asString().toUpperCase(), newSet);
                            scriptEntry.setFinished(true);
                        };
                        if (delayed) {
                            Bukkit.getScheduler().runTask((Plugin)Denizen.instance, storeSchem);
                        } else {
                            storeSchem.run();
                        }
                    }
                    catch (Exception ex) {
                        Runnable showError = () -> {
                            Debug.echoError(scriptEntry, "Error loading schematic file " + name.asString() + ".");
                            Debug.echoError(scriptEntry, ex);
                        };
                        if (delayed) {
                            Bukkit.getScheduler().runTask((Plugin)Denizen.instance, showError);
                        } else {
                            showError.run();
                        }
                        scriptEntry.setFinished(true);
                        return;
                    }
                };
                if (delayed) {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)Denizen.instance, loadRunnable);
                    break;
                }
                loadRunnable.run();
                scriptEntry.setFinished(true);
                break;
            }
            case UNLOAD: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    Debug.echoError(scriptEntry, "Schematic file " + name.asString() + " is not loaded.");
                    scriptEntry.setFinished(true);
                    return;
                }
                schematics.remove(name.asString().toUpperCase());
                scriptEntry.setFinished(true);
                break;
            }
            case ROTATE: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    Debug.echoError(scriptEntry, "Schematic file " + name.asString() + " is not loaded.");
                    scriptEntry.setFinished(true);
                    return;
                }
                if (angle == null) {
                    Debug.echoError(scriptEntry, "Missing angle argument!");
                    scriptEntry.setFinished(true);
                    return;
                }
                CuboidBlockSet schematic2 = schematics.get(name.asString().toUpperCase());
                if (schematic2.isModifying || schematic2.readingProcesses > 0) {
                    Debug.echoError("Cannot rotate schematic: schematic is currently processing another instruction.");
                    return;
                }
                SchematicCommand.rotateSchem(schematic2, angle.asInt(), delayed, () -> scriptEntry.setFinished(true));
                break;
            }
            case FLIP_X: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    Debug.echoError(scriptEntry, "Schematic file " + name.asString() + " is not loaded.");
                    scriptEntry.setFinished(true);
                    return;
                }
                CuboidBlockSet schematic3 = schematics.get(name.asString().toUpperCase());
                if (schematic3.isModifying || schematic3.readingProcesses > 0) {
                    Debug.echoError("Cannot flip schematic: schematic is currently processing another instruction.");
                    return;
                }
                schematic3.flipX();
                scriptEntry.setFinished(true);
                break;
            }
            case FLIP_Y: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    Debug.echoError(scriptEntry, "Schematic file " + name.asString() + " is not loaded.");
                    scriptEntry.setFinished(true);
                    return;
                }
                CuboidBlockSet schematic4 = schematics.get(name.asString().toUpperCase());
                if (schematic4.isModifying || schematic4.readingProcesses > 0) {
                    Debug.echoError("Cannot flip schematic: schematic is currently processing another instruction.");
                    return;
                }
                schematic4.flipY();
                scriptEntry.setFinished(true);
                break;
            }
            case FLIP_Z: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    Debug.echoError(scriptEntry, "Schematic file " + name.asString() + " is not loaded.");
                    scriptEntry.setFinished(true);
                    return;
                }
                CuboidBlockSet schematic5 = schematics.get(name.asString().toUpperCase());
                if (schematic5.isModifying || schematic5.readingProcesses > 0) {
                    Debug.echoError("Cannot flip schematic: schematic is currently processing another instruction.");
                    return;
                }
                schematic5.flipZ();
                scriptEntry.setFinished(true);
                break;
            }
            case PASTE: {
                CuboidBlockSet set;
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    Debug.echoError(scriptEntry, "Schematic file " + name.asString() + " is not loaded.");
                    scriptEntry.setFinished(true);
                    return;
                }
                if (location == null) {
                    Debug.echoError(scriptEntry, "Missing location argument!");
                    scriptEntry.setFinished(true);
                    return;
                }
                try {
                    BlockSet.InputParams input = new BlockSet.InputParams();
                    input.centerLocation = location;
                    input.noAir = noair;
                    input.fakeTo = fakeTo;
                    if (fakeTo != null && copyEntities) {
                        Debug.echoError(scriptEntry, "Cannot fake paste entities currently.");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    if (fakeDuration == null) {
                        fakeDuration = new DurationTag(0);
                    }
                    input.fakeDuration = fakeDuration;
                    if (mask != null) {
                        String maskText = mask.asString();
                        input.mask = new HashSet();
                        SchematicCommand.parseMask(scriptEntry, maskText, input.mask);
                    }
                    set = schematics.get(name.asString().toUpperCase());
                    if (set.isModifying) {
                        Debug.echoError("Cannot paste schematic: schematic is currently processing another instruction.");
                        return;
                    }
                    Consumer<CuboidBlockSet> pasteRunnable = schematic -> {
                        if (delayed) {
                            ++schematic.readingProcesses;
                            schematic.setBlocksDelayed(() -> {
                                try {
                                    if (copyEntities) {
                                        schematic.pasteEntities(location);
                                    }
                                }
                                finally {
                                    scriptEntry.setFinished(true);
                                    --schematic.readingProcesses;
                                }
                            }, input, maxDelayMs.asLong());
                        } else {
                            schematic.setBlocks(input);
                            if (copyEntities) {
                                schematic.pasteEntities(location);
                            }
                            scriptEntry.setFinished(true);
                        }
                    };
                    if (angle != null) {
                        CuboidBlockSet newSet = set.duplicate();
                        SchematicCommand.rotateSchem(newSet, angle.asInt(), delayed, () -> pasteRunnable.accept(newSet));
                        break;
                    }
                    pasteRunnable.accept(set);
                    break;
                }
                catch (Exception ex) {
                    Debug.echoError(scriptEntry, "Exception pasting schematic file " + name.asString() + ".");
                    Debug.echoError(scriptEntry, ex);
                    scriptEntry.setFinished(true);
                    return;
                }
            }
            case SAVE: {
                String extension;
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    Debug.echoError(scriptEntry, "Schematic file " + name.asString() + " is not loaded.");
                    return;
                }
                CuboidBlockSet set = schematics.get(name.asString().toUpperCase());
                if (set.isModifying) {
                    Debug.echoError("Cannot save schematic: schematic is currently processing another instruction.");
                    return;
                }
                String directory = URLDecoder.decode(System.getProperty("user.dir"));
                File f = new File(directory + "/plugins/Denizen/schematics/" + fname + (extension = ".schem"));
                if (!Utilities.canWriteToFile(f)) {
                    Debug.echoError("Cannot write to that file path due to security settings in Denizen/config.yml.");
                    scriptEntry.setFinished(true);
                    return;
                }
                Runnable saveRunnable = () -> {
                    try {
                        f.getParentFile().mkdirs();
                        FileOutputStream fs = new FileOutputStream(f);
                        SpongeSchematicHelper.saveToSpongeStream(set, fs);
                        fs.flush();
                        fs.close();
                    }
                    catch (Exception ex) {
                        Bukkit.getScheduler().runTask((Plugin)Denizen.instance, () -> {
                            Debug.echoError(scriptEntry, "Error saving schematic file " + fname + ".");
                            Debug.echoError(scriptEntry, ex);
                        });
                    }
                    Bukkit.getScheduler().runTask((Plugin)Denizen.instance, () -> {
                        --set.readingProcesses;
                        scriptEntry.setFinished(true);
                    });
                };
                if (delayed) {
                    ++set.readingProcesses;
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)Denizen.instance, saveRunnable);
                    break;
                }
                scriptEntry.setFinished(true);
                saveRunnable.run();
                break;
            }
        }
    }

    public void schematicTags(ReplaceableTagEvent event) {
        if (!event.matches("schematic")) {
            return;
        }
        Attribute attribute = event.getAttributes();
        String id = attribute.hasParam() ? attribute.getParam().toUpperCase() : null;
        if ((attribute = attribute.fulfill(1)).startsWith("list")) {
            event.setReplacedObject(new ListTag(schematics.keySet()).getObjectAttribute(attribute.fulfill(1)));
        }
        if (id == null) {
            return;
        }
        if (!schematics.containsKey(id)) {
            if (attribute.startsWith("exists")) {
                event.setReplacedObject(new ElementTag(false).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            Debug.echoError(attribute.getScriptEntry(), "Schematic file " + id + " is not loaded.");
            return;
        }
        CuboidBlockSet set = schematics.get(id);
        if (attribute.startsWith("exists")) {
            event.setReplacedObject(new ElementTag(true).getObjectAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("height")) {
            event.setReplacedObject(new ElementTag(set.y_length).getObjectAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("length")) {
            event.setReplacedObject(new ElementTag(set.z_height).getObjectAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("width")) {
            event.setReplacedObject(new ElementTag(set.x_width).getObjectAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("block") && attribute.hasParam() && LocationTag.matches(attribute.getParam())) {
            LocationTag location = attribute.paramAsType(LocationTag.class);
            FullBlockData block = set.blockAt(location.getX(), location.getY(), location.getZ());
            event.setReplacedObject(new MaterialTag(block.data).getObjectAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("origin")) {
            event.setReplacedObject(new LocationTag(null, (double)set.center_x, (double)set.center_y, set.center_z).getObjectAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("blocks")) {
            event.setReplacedObject(new ElementTag(set.blocks.length).getObjectAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("cuboid") && attribute.hasParam()) {
            LocationTag origin = attribute.paramAsType(LocationTag.class);
            event.setReplacedObject(set.getCuboid(origin).getObjectAttribute(attribute.fulfill(1)));
            return;
        }
    }

    private static enum Type {
        CREATE,
        LOAD,
        UNLOAD,
        ROTATE,
        PASTE,
        SAVE,
        FLIP_X,
        FLIP_Y,
        FLIP_Z;

    }
}

