/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.events.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.BinaryTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.commands.core.WebServerCommand;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import com.sun.net.httpserver.HttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebserverWebRequestScriptEvent
extends ScriptEvent {
    public static WebserverWebRequestScriptEvent instance;
    public WebServerCommand.WebserverInstance server;
    public HttpExchange exchange;
    public WebResponse response;
    public static HashMap<String, byte[]> responseFileCache;

    public byte[] getBody() {
        if (this.response.inputBody != null) {
            return this.response.inputBody;
        }
        try {
            int len;
            InputStream stream = this.exchange.getRequestBody();
            if (stream == null) {
                return null;
            }
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = stream.read(buffer, 0, 1024)) != -1) {
                bytesOut.write(buffer, 0, len);
            }
            this.response.inputBody = bytesOut.toByteArray();
            bytesOut.close();
            return this.response.inputBody;
        }
        catch (IOException ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    public WebserverWebRequestScriptEvent() {
        instance = this;
        this.registerCouldMatcher("webserver web request");
        this.registerSwitches("port", "path", "method", "has_response");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (path.switches.containsKey("method") && !WebserverWebRequestScriptEvent.runGenericSwitchCheck(path, "method", this.exchange.getRequestMethod())) {
            return false;
        }
        if (path.switches.containsKey("port") && !WebserverWebRequestScriptEvent.runGenericSwitchCheck(path, "port", String.valueOf(this.server.port))) {
            return false;
        }
        if (path.switches.containsKey("path") && !WebserverWebRequestScriptEvent.runGenericSwitchCheck(path, "path", this.exchange.getRequestURI().getPath())) {
            return false;
        }
        if (path.switches.containsKey("has_response") && !WebserverWebRequestScriptEvent.runGenericSwitchCheck(path, "has_response", String.valueOf(this.response.hasResponse))) {
            return false;
        }
        return super.matches(path);
    }

    public static byte[] readFileContent(File f) throws IOException {
        FileInputStream input = new FileInputStream(f);
        byte[] result = input.readAllBytes();
        input.close();
        return result;
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag) {
            String determination = determinationObj.toString();
            String determinationLow = CoreUtilities.toLowerCase(determination);
            if (determinationLow.startsWith("code:")) {
                String codeStr = determination.substring("code:".length());
                if (!new ElementTag(codeStr).isInt()) {
                    Debug.echoError("Invalid code '" + determination + "': not a number.");
                    return true;
                }
                this.response.code = new ElementTag(codeStr).asInt();
                return true;
            }
            if (determinationLow.startsWith("headers:")) {
                TagContext context = this.getTagContext(path);
                MapTag map = MapTag.valueOf(determination.substring("headers:".length()), context);
                if (map == null) {
                    Debug.echoError("Invalid headers map input (not a MapTag)");
                    return true;
                }
                for (Map.Entry<StringHolder, ObjectTag> header : map.map.entrySet()) {
                    this.exchange.getResponseHeaders().set(header.getKey().str, header.getValue().toString());
                }
                return true;
            }
            if (determinationLow.startsWith("raw_text_content:") && !this.response.hasResponse) {
                this.response.hasResponse = true;
                this.response.rawContent = determination.substring("raw_text_content:".length()).getBytes(StandardCharsets.UTF_8);
                return true;
            }
            if (determinationLow.startsWith("raw_binary_content:") && !this.response.hasResponse) {
                this.response.hasResponse = true;
                this.response.rawContent = BinaryTag.valueOf((String)determination.substring((int)"raw_binary_content:".length()), (TagContext)this.getTagContext((ScriptEvent.ScriptPath)path)).data;
                return true;
            }
            if ((determinationLow.startsWith("file:") || determinationLow.startsWith("cached_file:")) && !this.response.hasResponse) {
                byte[] cached;
                this.response.hasResponse = true;
                File root = new File(DenizenCore.implementation.getDataFolder(), CoreConfiguration.webserverRoot);
                boolean isCaching = determinationLow.startsWith("cached_file:");
                String filePathName = determination.substring((isCaching ? "cached_file:" : "file:").length());
                if (isCaching && (cached = responseFileCache.get(filePathName)) != null) {
                    this.response.cachedFile = cached;
                    return true;
                }
                File file = new File(root, filePathName);
                if (!DenizenCore.implementation.canReadFile(file)) {
                    Debug.echoError("File path '" + determination + "' is not permitted for access by the Denizen config file.");
                    return true;
                }
                try {
                    if (!file.getCanonicalPath().startsWith(root.getCanonicalPath())) {
                        Debug.echoError("File path '" + determination + "' is not within the web root.");
                        return true;
                    }
                }
                catch (IOException ex) {
                    Debug.echoError(ex);
                    return true;
                }
                if (isCaching) {
                    try {
                        this.response.cachedFile = WebserverWebRequestScriptEvent.readFileContent(file);
                    }
                    catch (IOException ex) {
                        Debug.echoError(ex);
                        return true;
                    }
                    responseFileCache.put(filePathName, this.response.cachedFile);
                } else {
                    this.response.fileResponse = file;
                }
                return true;
            }
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "method": {
                return new ElementTag(this.exchange.getRequestMethod(), true);
            }
            case "path": {
                return new ElementTag(this.exchange.getRequestURI().getPath(), true);
            }
            case "port": {
                return new ElementTag(this.server.port);
            }
            case "remote_address": {
                return new ElementTag(this.exchange.getRemoteAddress().toString(), true);
            }
            case "query": {
                MapTag output = new MapTag();
                String query = this.exchange.getRequestURI().getRawQuery();
                if (query != null) {
                    for (String pair : CoreUtilities.split(query, '&')) {
                        List<String> parts = CoreUtilities.split(pair, '=', 2);
                        try {
                            output.putObject(URLDecoder.decode(parts.get(0), "UTF-8"), new ElementTag(URLDecoder.decode(parts.get(1), "UTF-8"), true));
                        }
                        catch (UnsupportedEncodingException ex) {
                            Debug.echoError(ex);
                        }
                    }
                }
                return output;
            }
            case "raw_query": {
                return this.exchange.getRequestURI().getRawQuery() == null ? null : new ElementTag(this.exchange.getRequestURI().getRawQuery(), true);
            }
            case "raw_user_info": {
                return this.exchange.getRequestURI().getRawUserInfo() == null ? null : new ElementTag(this.exchange.getRequestURI().getRawUserInfo(), null);
            }
            case "headers": {
                MapTag output = new MapTag();
                for (Map.Entry<String, List<String>> header : this.exchange.getRequestHeaders().entrySet()) {
                    ListTag list = new ListTag();
                    for (String str : header.getValue()) {
                        list.addObject(new ElementTag(str, true));
                    }
                    output.putObject(header.getKey(), list);
                }
                return output;
            }
            case "has_response": {
                return new ElementTag(this.response.hasResponse);
            }
            case "body": {
                return new ElementTag(new String(this.getBody(), StandardCharsets.UTF_8));
            }
            case "body_binary": {
                return new BinaryTag(this.getBody());
            }
        }
        return super.getContext(name);
    }

    public static void fire(WebServerCommand.WebserverInstance server, HttpExchange exchange) {
        WebserverWebRequestScriptEvent.instance.server = server;
        WebserverWebRequestScriptEvent.instance.exchange = exchange;
        WebResponse response = WebserverWebRequestScriptEvent.instance.response = new WebResponse();
        instance.fire();
        DenizenCore.runAsync(() -> {
            block2: {
                try {
                    byte[] body = response.rawContent != null ? response.rawContent : (response.cachedFile != null ? response.cachedFile : (response.fileResponse != null ? WebserverWebRequestScriptEvent.readFileContent(response.fileResponse) : new byte[]{}));
                    exchange.sendResponseHeaders(response.code, body.length);
                    OutputStream os = exchange.getResponseBody();
                    os.write(body);
                    os.close();
                    exchange.close();
                }
                catch (Throwable ex) {
                    if (server.ignoreErrors && ex instanceof IOException) break block2;
                    Debug.echoError(ex);
                }
            }
        });
    }

    static {
        responseFileCache = new HashMap();
    }

    public static class WebResponse {
        public int code = 200;
        public byte[] rawContent;
        public File fileResponse;
        public byte[] cachedFile;
        public boolean hasResponse = false;
        public byte[] inputBody;
    }
}

