/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.properties;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.Material;
import org.bukkit.entity.Witch;

public class EntityDrinkingPotion
implements Property {
    public static final String[] handledMechs = new String[]{"drinking_potion", "potion_drink_duration"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof Witch;
    }

    public static EntityDrinkingPotion getFrom(ObjectTag _entity) {
        if (!EntityDrinkingPotion.describes(_entity)) {
            return null;
        }
        return new EntityDrinkingPotion((EntityTag)_entity);
    }

    private EntityDrinkingPotion(EntityTag _entity) {
        this.entity = _entity;
    }

    public static void register() {
        PropertyParser.registerTag(EntityDrinkingPotion.class, ItemTag.class, (String)"drinking_potion", (attribute, object) -> new ItemTag(object.getWitch().getDrinkingPotion()), (String[])new String[0]);
        PropertyParser.registerTag(EntityDrinkingPotion.class, DurationTag.class, (String)"potion_drink_duration", (attribute, object) -> new DurationTag((long)object.getWitch().getPotionUseTimeLeft()), (String[])new String[0]);
    }

    public Witch getWitch() {
        return (Witch)this.entity.getBukkitEntity();
    }

    public String getPropertyString() {
        return null;
    }

    public String getPropertyId() {
        return "drinking_potion";
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("drinking_potion") && mechanism.requireObject(ItemTag.class)) {
            ItemTag potion = (ItemTag)mechanism.valueAsType(ItemTag.class);
            if (potion.getBukkitMaterial() != Material.POTION) {
                mechanism.echoError("Invalid item input '" + potion + "': item must be a potion");
                return;
            }
            this.getWitch().setDrinkingPotion(potion.getItemStack());
        }
        if (mechanism.matches("potion_drink_duration") && mechanism.requireObject(DurationTag.class)) {
            this.getWitch().setPotionUseTimeLeft(((DurationTag)mechanism.valueAsType(DurationTag.class)).getTicksAsInt());
        }
    }
}

