/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDamageAbortEvent;

public class PlayerStopsDamagingBlockScriptEvent
extends BukkitScriptEvent
implements Listener {
    LocationTag location;
    MaterialTag material;
    BlockDamageAbortEvent event;

    public PlayerStopsDamagingBlockScriptEvent() {
        this.registerCouldMatcher("player stops damaging <block>");
        this.registerSwitches("with");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!path.tryArgObject(3, this.material)) {
            return false;
        }
        if (!PlayerStopsDamagingBlockScriptEvent.runWithCheck(path, new ItemTag(this.event.getItemInHand()))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "location" -> this.location;
            case "material" -> this.material;
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void playerStopsDamagingBlockEvent(BlockDamageAbortEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.location = new LocationTag(event.getBlock().getLocation());
        this.material = new MaterialTag(event.getBlock());
        this.event = event;
        this.fire((Event)event);
    }
}

