/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.tags.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.events.core.TickScriptEvent;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.JavaReflectedObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.commands.CommandRegistry;
import com.denizenscript.denizencore.scripts.commands.core.AdjustCommand;
import com.denizenscript.denizencore.scripts.commands.core.MongoCommand;
import com.denizenscript.denizencore.scripts.commands.core.SQLCommand;
import com.denizenscript.denizencore.scripts.commands.queue.RunLaterCommand;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.PseudoObjectTagBase;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.QueueWordList;
import com.denizenscript.denizencore.utilities.RedisHelper;
import com.denizenscript.denizencore.utilities.ReflectionRefuse;
import com.denizenscript.denizencore.utilities.SimplexNoise;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.DebugInternals;
import java.io.File;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

public class UtilTagBase
extends PseudoObjectTagBase<UtilTagBase> {
    public static UtilTagBase instance;
    public static final long serverStartTimeMillis;

    public UtilTagBase() {
        instance = this;
        TagManager.registerStaticTagBaseHandler(UtilTagBase.class, "util", t -> instance);
        AdjustCommand.specialAdjustables.put("system", mechanism -> this.tagProcessor.processMechanism(instance, (Mechanism)mechanism));
    }

    @Override
    public void register() {
        this.tagProcessor.registerTag(ElementTag.class, "random", (attribute, object) -> {
            String stc;
            attribute.fulfill(1);
            if (attribute.startsWith("int")) {
                stc = attribute.getParam();
                attribute.fulfill(1);
                if (attribute.startsWith("to") && ArgumentHelper.matchesInteger(stc) && ArgumentHelper.matchesInteger(attribute.getParam())) {
                    int max;
                    int min = Integer.parseInt(stc);
                    if (min > (max = attribute.getIntParam())) {
                        int store = min;
                        min = max;
                        max = store;
                    }
                    return new ElementTag(CoreUtilities.getRandom().nextInt(max - min + 1) + min);
                }
            }
            if (attribute.startsWith("decimal") && attribute.hasParam()) {
                stc = attribute.getParam();
                attribute.fulfill(1);
                if (attribute.startsWith("to") && ArgumentHelper.matchesDouble(stc) && ArgumentHelper.matchesDouble(attribute.getParam())) {
                    double max;
                    double min = Double.parseDouble(stc);
                    if (min > (max = Double.parseDouble(attribute.getParam()))) {
                        double store = min;
                        min = max;
                        max = store;
                    }
                    return new ElementTag(CoreUtilities.getRandom().nextDouble() * (max - min) + min);
                }
            } else {
                if (attribute.startsWith("decimal")) {
                    Deprecations.oldUtilRandomTags.warn(attribute.context);
                    return new ElementTag(CoreUtilities.getRandom().nextDouble());
                }
                if (attribute.startsWith("boolean")) {
                    Deprecations.oldUtilRandomTags.warn(attribute.context);
                    return new ElementTag(CoreUtilities.getRandom().nextBoolean());
                }
                if (attribute.startsWith("gauss")) {
                    Deprecations.oldUtilRandomTags.warn(attribute.context);
                    return new ElementTag(CoreUtilities.getRandom().nextGaussian());
                }
                if (attribute.startsWith("uuid")) {
                    Deprecations.oldUtilRandomTags.warn(attribute.context);
                    return new ElementTag(UUID.randomUUID().toString());
                }
                if (attribute.startsWith("duuid")) {
                    int size = QueueWordList.FinalWordList.size();
                    String id = (attribute.hasParam() ? attribute.getParam() : "DUUID") + "_" + QueueWordList.FinalWordList.get(CoreUtilities.getRandom().nextInt(size)) + QueueWordList.FinalWordList.get(CoreUtilities.getRandom().nextInt(size)) + QueueWordList.FinalWordList.get(CoreUtilities.getRandom().nextInt(size));
                    return new ElementTag(id);
                }
            }
            return null;
        }, new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, "random_decimal", (attribute, object) -> new ElementTag(CoreUtilities.getRandom().nextDouble()), new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, ElementTag.class, "random_chance", (attribute, object, chance) -> new ElementTag(CoreUtilities.getRandom().nextDouble() * 100.0 <= chance.asDouble()), new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, "random_boolean", (attribute, object) -> new ElementTag(CoreUtilities.getRandom().nextBoolean()), new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, "random_gauss", (attribute, object) -> new ElementTag(CoreUtilities.getRandom().nextGaussian()), new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, "random_uuid", (attribute, object) -> new ElementTag(UUID.randomUUID().toString()), new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, MapTag.class, "random_simplex", (attribute, object, input) -> {
            ElementTag objX = input.getRequiredObjectAs("x", ElementTag.class, attribute);
            ObjectTag objY = input.getObject("y");
            ObjectTag objZ = input.getObject("z");
            ObjectTag objW = input.getObject("w");
            double x = objX == null ? 0.0 : objX.asElement().asDouble();
            double y = objY == null ? 0.0 : objY.asElement().asDouble();
            double z = objZ == null ? 0.0 : objZ.asElement().asDouble();
            double w = objW == null ? 0.0 : objW.asElement().asDouble();
            double res = 0.0;
            if (objW != null && objZ != null && objY != null && objX != null) {
                res = SimplexNoise.noise(x, y, z, w);
            } else if (objZ != null && objY != null && objX != null && objW == null) {
                res = SimplexNoise.noise(x, y, z);
            } else if (objY != null && objX != null && objW == null && objZ == null) {
                res = SimplexNoise.noise(y, x);
            } else if (objX != null && objW == null && objZ == null && objY == null) {
                res = SimplexNoise.noise(y, x);
            } else {
                return null;
            }
            return new ElementTag(res);
        }, new String[0]);
        this.tagProcessor.registerStaticTag(ListTag.class, MapTag.class, "list_numbers", (attribute, object, input) -> {
            ElementTag toElement = input.getRequiredObjectAs("to", ElementTag.class, attribute);
            if (toElement == null || !toElement.isInt()) {
                return null;
            }
            long to = toElement.asInt();
            long from = input.getElement("from", "1").asInt();
            long every = input.getElement("every", "1").asInt();
            ListTag result = new ListTag();
            for (long i = from; i <= to; i += every) {
                result.addObject(new ElementTag(i));
            }
            return result;
        }, new String[0]);
        this.tagProcessor.registerStaticTag(ListTag.class, ElementTag.class, "list_numbers_to", (attribute, object, toElement) -> {
            int to = toElement.asInt();
            ListTag result = new ListTag();
            for (int i = 1; i <= to; ++i) {
                result.add(String.valueOf(i));
            }
            return result;
        }, new String[0]);
        this.tagProcessor.registerStaticTag(ListTag.class, ElementTag.class, "empty_list_entries", (attribute, object, toElement) -> {
            int to = toElement.asInt();
            ListTag result = new ListTag();
            for (int i = 1; i <= to; ++i) {
                result.add("");
            }
            return result;
        }, new String[0]);
        this.tagProcessor.registerStaticTag(ElementTag.class, "short_max", (attribute, object) -> new ElementTag(Short.MAX_VALUE), new String[0]);
        this.tagProcessor.registerStaticTag(ElementTag.class, "short_min", (attribute, object) -> new ElementTag(Short.MIN_VALUE), new String[0]);
        this.tagProcessor.registerStaticTag(ElementTag.class, "int_max", (attribute, object) -> new ElementTag(Integer.MAX_VALUE), new String[0]);
        this.tagProcessor.registerStaticTag(ElementTag.class, "int_min", (attribute, object) -> new ElementTag(Integer.MIN_VALUE), new String[0]);
        this.tagProcessor.registerStaticTag(ElementTag.class, "long_max", (attribute, object) -> new ElementTag(Long.MAX_VALUE), new String[0]);
        this.tagProcessor.registerStaticTag(ElementTag.class, "long_min", (attribute, object) -> new ElementTag(Long.MIN_VALUE), new String[0]);
        this.tagProcessor.registerStaticTag(ElementTag.class, "pi", (attribute, object) -> new ElementTag(Math.PI), new String[0]);
        this.tagProcessor.registerStaticTag(ElementTag.class, "tau", (attribute, object) -> new ElementTag(Math.PI * 2), new String[0]);
        this.tagProcessor.registerStaticTag(ElementTag.class, "e", (attribute, object) -> new ElementTag(Math.E), new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "list_denizen_commands", (attribute, object) -> new ListTag(DenizenCore.commandRegistry.instances.keySet()), new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "list_tag_bases", (attribute, object) -> new ListTag(TagManager.baseTags.keySet()), new String[0]);
        this.tagProcessor.registerTag(TimeTag.class, "time_at", (attribute, object) -> {
            Deprecations.timeTagRewrite.warn(attribute.context);
            String[] dateComponents = attribute.getParam().split(" ");
            String[] ymd = dateComponents[0].split("/");
            int year = Integer.parseInt(ymd[0]);
            int month = Integer.parseInt(ymd[1]) - 1;
            int day = Integer.parseInt(ymd[2]);
            int hour = 0;
            int minute = 0;
            int second = 0;
            int millisecond = 0;
            if (dateComponents.length > 1) {
                String[] hms = dateComponents[1].split(":");
                hour = Integer.parseInt(hms[0]);
                minute = Integer.parseInt(hms[1]);
                second = Integer.parseInt(hms[2]);
                if (hms.length > 3) {
                    millisecond = Integer.parseInt(hms[3]);
                }
            }
            Calendar calendar = Calendar.getInstance();
            calendar.set(year, month, day, hour, minute, second);
            TimeTag result = new TimeTag(calendar.getTimeInMillis() + (long)millisecond);
            return result;
        }, new String[0]);
        this.tagProcessor.registerTag(TimeTag.class, "time_now", (attribute, object) -> TimeTag.now(), new String[0]);
        this.tagProcessor.registerTag(ObjectTag.class, "date", (attribute, object) -> {
            Deprecations.timeTagRewrite.warn(attribute.context);
            Calendar calendar = Calendar.getInstance();
            Date currentDate = new Date();
            SimpleDateFormat format = new SimpleDateFormat();
            if (attribute.startsWith("time", 2)) {
                attribute.fulfill(1);
                if (attribute.startsWith("twentyfour_hour", 2)) {
                    attribute.fulfill(1);
                    format.applyPattern("k:mm");
                    return new ElementTag(format.format(currentDate));
                }
                if (attribute.startsWith("year", 2)) {
                    attribute.fulfill(1);
                    return new ElementTag(calendar.get(1));
                }
                if (attribute.startsWith("month", 2)) {
                    attribute.fulfill(1);
                    return new ElementTag(calendar.get(2) + 1);
                }
                if (attribute.startsWith("week", 2)) {
                    attribute.fulfill(1);
                    return new ElementTag(calendar.get(3));
                }
                if (attribute.startsWith("day_of_week", 2)) {
                    attribute.fulfill(1);
                    return new ElementTag(calendar.get(7));
                }
                if (attribute.startsWith("day", 2)) {
                    attribute.fulfill(1);
                    return new ElementTag(calendar.get(5));
                }
                if (attribute.startsWith("hour", 2)) {
                    attribute.fulfill(1);
                    return new ElementTag(calendar.get(11));
                }
                if (attribute.startsWith("minute", 2)) {
                    attribute.fulfill(1);
                    return new ElementTag(calendar.get(12));
                }
                if (attribute.startsWith("second", 2)) {
                    attribute.fulfill(1);
                    return new ElementTag(calendar.get(13));
                }
                if (attribute.startsWith("duration", 2)) {
                    attribute.fulfill(1);
                    return new DurationTag(System.currentTimeMillis() / 50L);
                }
                if (attribute.startsWith("zone", 2)) {
                    attribute.fulfill(1);
                    TimeZone tz = Calendar.getInstance().getTimeZone();
                    return new ElementTag(tz.getDisplayName(tz.inDaylightTime(currentDate), 0));
                }
                if (attribute.startsWith("formatted_zone", 2)) {
                    attribute.fulfill(1);
                    TimeZone tz = Calendar.getInstance().getTimeZone();
                    return new ElementTag(tz.getDisplayName(tz.inDaylightTime(currentDate), 1));
                }
                format.applyPattern("K:mm a");
                return new ElementTag(format.format(currentDate));
            }
            if (attribute.startsWith("format", 2) && attribute.hasParam()) {
                try {
                    attribute.fulfill(1);
                    format.applyPattern(attribute.getParam());
                    return new ElementTag(format.format(currentDate));
                }
                catch (Exception ex) {
                    Debug.echoError("Error: invalid pattern '" + attribute.getParam() + "'");
                    Debug.echoError(ex);
                }
            } else {
                format.applyPattern("EEE, MMM d, yyyy");
                return new ElementTag(format.format(currentDate));
            }
            return null;
        }, new String[0]);
        this.tagProcessor.registerStaticTag(MapTag.class, ElementTag.class, "parse_yaml", (attribute, object, rawYaml) -> (MapTag)CoreUtilities.objectToTagForm(YamlConfiguration.load((String)rawYaml.asString()).contents, attribute.context), new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "queues", (attribute, object) -> {
            ListTag list = new ListTag();
            for (ScriptQueue queue : ScriptQueue.getQueues()) {
                list.addObject(new QueueTag(queue));
            }
            return list;
        }, new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, "event_stats", (attribute, object) -> new ElementTag(ScriptQueue.getStats()), new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "event_stats_data", (attribute, object) -> ScriptQueue.getStatsRawData(), new String[0]);
        this.tagProcessor.registerStaticTag(ElementTag.class, "default_encoding", (attribute, object) -> new ElementTag(Charset.defaultCharset().name()), new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "runlater_ids", (attribute, object) -> new ListTag(new ArrayList<String>(RunLaterCommand.trackedById.keySet()), true), new String[0]);
        this.tagProcessor.registerStaticTag(ElementTag.class, "java_version", (attribute, object) -> new ElementTag(System.getProperty("java.version")), new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, ElementTag.class, "has_file", (attribute, object, fileName) -> {
            File f = new File(DenizenCore.implementation.getDataFolder(), fileName.asString());
            try {
                if (!DenizenCore.implementation.canReadFile(f)) {
                    Debug.echoError("Cannot read from that file path due to security settings in Denizen/config.yml.");
                    return null;
                }
            }
            catch (Exception e) {
                Debug.echoError(e);
                return null;
            }
            return new ElementTag(f.exists());
        }, new String[0]);
        this.tagProcessor.registerTag(ListTag.class, ElementTag.class, "list_files", (attribute, object, folderName) -> {
            File folder = new File(DenizenCore.implementation.getDataFolder(), folderName.asString());
            try {
                if (!DenizenCore.implementation.canReadFile(folder)) {
                    Debug.echoError("Cannot read from that file path due to security settings in Denizen/config.yml.");
                    return null;
                }
                if (!folder.exists() || !folder.isDirectory()) {
                    attribute.echoError("Invalid path specified. No directory exists at that path.");
                    return null;
                }
            }
            catch (Exception e) {
                Debug.echoError(e);
                return null;
            }
            File[] files = folder.listFiles();
            if (files == null) {
                return null;
            }
            ListTag list = new ListTag();
            for (File file : files) {
                list.add(file.getName());
            }
            return list;
        }, new String[0]);
        this.tagProcessor.registerStaticTag(TimeTag.class, "started_time", (attribute, object) -> new TimeTag(CoreUtilities.monotonicMillisToReal(DenizenCore.startTime)), new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, "disk_free", (attribute, object) -> {
            File folder = DenizenCore.implementation.getDataFolder();
            return new ElementTag(folder.getUsableSpace());
        }, new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, "disk_total", (attribute, object) -> {
            File folder = DenizenCore.implementation.getDataFolder();
            return new ElementTag(folder.getTotalSpace());
        }, new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, "disk_usage", (attribute, object) -> {
            File folder = DenizenCore.implementation.getDataFolder();
            return new ElementTag(folder.getTotalSpace() - folder.getFreeSpace());
        }, new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, "ram_allocated", (attribute, object) -> new ElementTag(Runtime.getRuntime().totalMemory()), new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, "ram_max", (attribute, object) -> new ElementTag(Runtime.getRuntime().maxMemory()), new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, "ram_free", (attribute, object) -> new ElementTag(Runtime.getRuntime().freeMemory()), new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, "ram_usage", (attribute, object) -> new ElementTag(Runtime.getRuntime().maxMemory() - Runtime.getRuntime().freeMemory()), new String[0]);
        this.tagProcessor.registerStaticTag(ElementTag.class, "available_processors", (attribute, object) -> new ElementTag(Runtime.getRuntime().availableProcessors()), new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, "current_tick", (attribute, object) -> new ElementTag(TickScriptEvent.instance.ticks), new String[0]);
        this.tagProcessor.registerTag(DurationTag.class, "delta_time_since_start", (attribute, object) -> new DurationTag(TickScriptEvent.instance.ticks), new String[0]);
        this.tagProcessor.registerTag(DurationTag.class, "real_time_since_start", (attribute, object) -> new DurationTag((double)(CoreUtilities.monotonicMillis() - serverStartTimeMillis) / 1000.0), new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, "current_time_millis", (attribute, object) -> new ElementTag(System.currentTimeMillis()), new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "notes", (attribute, object) -> {
            ListTag allNotables = new ListTag();
            if (attribute.hasParam()) {
                String type = CoreUtilities.toLowerCase(attribute.getParam());
                for (Map.Entry<String, Class> typeClass : NoteManager.namesToTypes.entrySet()) {
                    if (!type.equals(CoreUtilities.toLowerCase(typeClass.getKey()))) continue;
                    for (Object notable : NoteManager.getAllType(typeClass.getValue())) {
                        allNotables.addObject((ObjectTag)notable);
                    }
                    break;
                }
            } else {
                for (Notable notable : NoteManager.nameToObject.values()) {
                    allNotables.addObject((ObjectTag)((Object)notable));
                }
            }
            return allNotables;
        }, new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "sql_connections", (attribute, object) -> {
            ListTag list = new ListTag();
            for (Map.Entry<String, Connection> entry : SQLCommand.connections.entrySet()) {
                try {
                    if (!entry.getValue().isClosed()) {
                        list.addObject(new ElementTag(entry.getKey(), true));
                        continue;
                    }
                    SQLCommand.connections.remove(entry.getKey());
                }
                catch (SQLException e) {
                    Debug.echoError(attribute.getScriptEntry(), e);
                }
            }
            return list;
        }, new String[0]);
        if (CommandRegistry.shouldRegisterByClass("Redis command", "redis.clients.jedis.Jedis")) {
            this.tagProcessor.registerTag(ListTag.class, "redis_connections", (attribute, object) -> {
                ListTag list = new ListTag();
                for (String entry : RedisHelper.connections.keySet()) {
                    list.addObject(new ElementTag(entry, true));
                }
                return list;
            }, new String[0]);
        }
        if (CommandRegistry.shouldRegisterByClass("Mongo command", "com.mongodb.client.MongoClient")) {
            this.tagProcessor.registerTag(ListTag.class, "mongo_connections", (attribute, object) -> {
                ListTag list = new ListTag();
                for (String entry : MongoCommand.mongoConnections.keySet()) {
                    list.addObject(new ElementTag(entry, true));
                }
                return list;
            }, new String[0]);
        }
        this.tagProcessor.registerTag(ListTag.class, "scripts", (attribute, object) -> {
            ListTag scripts = new ListTag();
            for (ScriptContainer script : ScriptRegistry.scriptContainers.values()) {
                scripts.addObject(new ScriptTag(script));
            }
            return scripts;
        }, new String[0]);
        this.tagProcessor.registerTag(TimeTag.class, "last_reload", (attribute, object) -> new TimeTag(CoreUtilities.monotonicMillisToReal(DenizenCore.lastReloadTime)), new String[0]);
        this.tagProcessor.registerStaticTag(JavaReflectedObjectTag.class, ElementTag.class, "reflect_class", (attribute, object, name) -> {
            if (!CoreConfiguration.allowReflectionFieldReads) {
                attribute.echoError("Cannot reflect a class due to config reflection restrictions.");
                return null;
            }
            if (!attribute.hasParam()) {
                return null;
            }
            try {
                Class<?> clazz = Class.forName(name.asString());
                if (clazz.isAnnotationPresent(ReflectionRefuse.class)) {
                    attribute.echoError("Cannot reflect class '" + clazz.getName() + "' as it is marked for reflection refusal.");
                    return null;
                }
                return new JavaReflectedObjectTag(clazz);
            }
            catch (ClassNotFoundException ex) {
                attribute.echoError("Class not found.");
                return null;
            }
        }, new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, "stack_trace", (attribute, object) -> new ElementTag(DebugInternals.getFullExceptionMessage(new RuntimeException("TRACE"), false)), new String[0]);
        this.tagProcessor.registerTag(ListTag.class, "java_class_context", (attribute, object) -> new ListTag(StackWalker.getInstance(StackWalker.Option.SHOW_HIDDEN_FRAMES).walk(stackFrameStream -> stackFrameStream.map(stackFrame -> new ElementTag(stackFrame.getClassName(), true)).toList())), new String[0]);
        this.tagProcessor.registerTag(ElementTag.class, "debug_enabled", (attribute, object) -> new ElementTag(CoreConfiguration.shouldShowDebug), new String[0]);
        this.tagProcessor.registerMechanism("redirect_logging", false, ElementTag.class, (object, mechanism, input) -> {
            if (!CoreConfiguration.allowConsoleRedirection) {
                mechanism.echoError("Console redirection disabled by administrator (refer to mechanism documentation).");
                return;
            }
            if (input.asBoolean()) {
                DenizenCore.logInterceptor.redirectOutput();
            } else {
                DenizenCore.logInterceptor.standardOutput();
            }
        }, new String[0]);
        this.tagProcessor.registerMechanism("cancel_runlater", false, ElementTag.class, (object, mechanism, input) -> {
            RunLaterCommand.FutureRunData runner = RunLaterCommand.trackedById.remove(input.asLowerString());
            if (runner != null) {
                runner.cancelled = true;
            }
        }, new String[0]);
        this.tagProcessor.registerMechanism("reset_event_stats", false, (object, mechanism) -> {
            for (ScriptEvent scriptEvent : ScriptEvent.events) {
                scriptEvent.eventData.stats_fires = 0L;
                scriptEvent.eventData.stats_scriptFires = 0L;
                scriptEvent.eventData.stats_nanoTimes = 0L;
            }
        }, new String[0]);
        this.tagProcessor.registerMechanism("cleanmem", false, (object, mechanism) -> System.gc(), new String[0]);
        this.tagProcessor.registerMechanism("delete_file", false, ElementTag.class, (object, mechanism, input) -> {
            if (!CoreConfiguration.allowFileDeletion) {
                mechanism.echoError("File deletion disabled by administrator (refer to mechanism documentation).");
                return;
            }
            File file = new File(DenizenCore.implementation.getDataFolder(), input.asString());
            if (!DenizenCore.implementation.canWriteToFile(file)) {
                mechanism.echoError("Cannot write to that file path due to security settings in Denizen/config.yml.");
                return;
            }
            try {
                if (!file.delete()) {
                    mechanism.echoError("Failed to delete file: returned false");
                }
            }
            catch (Exception e) {
                mechanism.echoError("Failed to delete file: " + e.getMessage());
            }
        }, new String[0]);
    }

    static {
        serverStartTimeMillis = CoreUtilities.monotonicMillis();
    }
}

