/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PlayerReceivesTablistUpdateScriptEvent
extends BukkitScriptEvent {
    public static PlayerReceivesTablistUpdateScriptEvent instance;
    public Player player;
    public TabPacketData data;
    public static boolean enabled;

    public PlayerReceivesTablistUpdateScriptEvent() {
        instance = this;
        this.registerCouldMatcher("player receives tablist update");
        this.registerSwitches("mode");
    }

    @Override
    public void init() {
        NetworkInterceptHelper.enable();
        enabled = true;
    }

    @Override
    public void destroy() {
        enabled = false;
    }

    @Override
    public void cancellationChanged() {
        if (this.cancelled && !CoreConfiguration.allowRestrictedActions) {
            Debug.echoError("Cannot use 'receives tablist update' event to cancel a tablist packet: 'Allow restricted actions' is disabled in Denizen config.yml.");
            return;
        }
        this.data.cancelled = this.cancelled;
        this.data.modified = true;
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.player.getLocation())) {
            return false;
        }
        if (!PlayerReceivesTablistUpdateScriptEvent.runGenericSwitchCheck(path, "mode", this.data.mode)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        String determinationLow = CoreUtilities.toLowerCase(determination);
        if (determinationLow.contains(":")) {
            if (determinationLow.startsWith("latency:")) {
                this.data.modified = true;
                this.data.latency = Integer.parseInt(determination.substring("latency:".length()));
                return true;
            }
            if (determinationLow.startsWith("name:")) {
                if (!CoreConfiguration.allowRestrictedActions) {
                    Debug.echoError("Cannot use 'receives tablist update' event to edit a display name: 'Allow restricted actions' is disabled in Denizen config.yml.");
                    return true;
                }
                this.data.modified = true;
                this.data.name = determination.substring("name:".length());
                return true;
            }
            if (determinationLow.startsWith("display:")) {
                if (!CoreConfiguration.allowRestrictedActions) {
                    Debug.echoError("Cannot use 'receives tablist update' event to edit a display name: 'Allow restricted actions' is disabled in Denizen config.yml.");
                    return true;
                }
                this.data.modified = true;
                this.data.name = determination.substring("display:".length());
                return true;
            }
            if (determinationLow.startsWith("gamemode:")) {
                this.data.modified = true;
                this.data.gamemode = determination.substring("gamemode:".length());
                return true;
            }
            if (determinationLow.startsWith("skin_blob:")) {
                String blob = determination.substring("skin_blob:".length());
                int semicolon = blob.indexOf(59);
                if (semicolon == -1) {
                    Debug.echoError("Invalid skin blob!");
                    return true;
                }
                this.data.modified = true;
                this.data.texture = blob.substring(0, semicolon);
                this.data.signature = blob.substring(semicolon + 1);
                return true;
            }
            if (determinationLow.startsWith("listed:")) {
                this.data.modified = true;
                this.data.isListed = new ElementTag(determination.substring("listed:".length())).asBoolean();
                return true;
            }
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.player);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "name": {
                return new ElementTag(this.data.name);
            }
            case "uuid": {
                return new ElementTag(this.data.id.toString());
            }
            case "mode": {
                return new ElementTag(this.data.mode);
            }
            case "display": {
                return new ElementTag(this.data.display);
            }
            case "gamemode": {
                return new ElementTag(this.data.gamemode);
            }
            case "skin_blob": {
                return new ElementTag(this.data.texture + ";" + this.data.signature);
            }
            case "latency": {
                return new ElementTag(this.data.latency);
            }
            case "listed": {
                return new ElementTag(this.data.isListed);
            }
        }
        return super.getContext(name);
    }

    public static void fire(Player player, TabPacketData data) {
        PlayerReceivesTablistUpdateScriptEvent.instance.player = player;
        PlayerReceivesTablistUpdateScriptEvent.instance.data = data;
        instance.fire();
    }

    static {
        enabled = false;
    }

    public static class TabPacketData {
        public UUID id;
        public String mode;
        public String name;
        public String display;
        public String gamemode;
        public String texture;
        public String signature;
        public int latency;
        public boolean isListed;
        public boolean cancelled = false;
        public boolean modified = false;

        public TabPacketData(String mode, UUID id, boolean isListed, String name, String display, String gamemode, String texture, String signature, int latency) {
            this.mode = mode;
            this.id = id;
            this.name = name;
            this.display = display;
            this.gamemode = gamemode;
            this.texture = texture;
            this.signature = signature;
            this.latency = latency;
            this.isListed = isListed;
        }
    }
}

