/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.trade;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.TradeTag;
import com.denizenscript.denizen.objects.properties.trade.TradeProperty;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.inventory.ItemStack;

public class TradeInputs
extends TradeProperty {
    public static boolean describes(TradeTag recipe) {
        return true;
    }

    @Override
    public ListTag getPropertyValue() {
        return this.getIngredientsList();
    }

    @Override
    public String getPropertyId() {
        return "inputs";
    }

    public ListTag getIngredientsList() {
        ListTag result = new ListTag();
        for (ItemStack item : this.getRecipe().getIngredients()) {
            result.addObject(new ItemTag(item));
        }
        return result;
    }

    public static void register() {
        PropertyParser.registerTag(TradeInputs.class, ListTag.class, "inputs", (attribute, prop) -> prop.getIngredientsList(), new String[0]);
        PropertyParser.registerMechanism(TradeInputs.class, ListTag.class, "inputs", (prop, mechanism, inList) -> {
            List<Object> ingredients = new ArrayList<ItemStack>();
            List<ItemTag> list = inList.filter(ItemTag.class, mechanism.context);
            if (!mechanism.hasValue() || list.isEmpty()) {
                prop.getRecipe().setIngredients(ingredients);
                return;
            }
            for (ItemTag item : list) {
                ingredients.add(item.getItemStack());
            }
            if (ingredients.size() > 2) {
                mechanism.echoError("Trade recipe input was given " + list.size() + " items. Only using the first two items!");
                ingredients = ingredients.subList(0, 2);
            }
            prop.getRecipe().setIngredients(ingredients);
        }, new String[0]);
    }
}

