/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.inventory;

import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.TradeTag;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.ObjectProperty;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.inventory.MerchantRecipe;

public class InventoryTrades
extends ObjectProperty<InventoryTag> {
    public static boolean describes(InventoryTag inventory) {
        return inventory.getInventory() instanceof MerchantInventory;
    }

    @Override
    public ListTag getPropertyValue() {
        ListTag recipes = this.getTradeRecipes();
        if (recipes.isEmpty()) {
            return null;
        }
        return recipes;
    }

    @Override
    public String getPropertyId() {
        return "trades";
    }

    public ListTag getTradeRecipes() {
        ArrayList<TradeTag> recipes = new ArrayList<TradeTag>();
        for (MerchantRecipe recipe : ((MerchantInventory)((InventoryTag)this.object).getInventory()).getMerchant().getRecipes()) {
            recipes.add(new TradeTag(recipe).duplicate());
        }
        return new ListTag((Collection<? extends ObjectTag>)recipes);
    }

    public static void register() {
        PropertyParser.registerTag(InventoryTrades.class, ListTag.class, "trades", (attribute, inventory) -> inventory.getTradeRecipes(), new String[0]);
        PropertyParser.registerMechanism(InventoryTrades.class, ListTag.class, "trades", (prop, mechanism, param) -> {
            ArrayList<MerchantRecipe> recipes = new ArrayList<MerchantRecipe>();
            for (TradeTag recipe : param.filter(TradeTag.class, mechanism.context)) {
                recipes.add(recipe.getRecipe());
            }
            ((MerchantInventory)((InventoryTag)prop.object).getInventory()).getMerchant().setRecipes(recipes);
        }, new String[0]);
    }
}

