/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.properties.material.MaterialProperty;
import com.denizenscript.denizencore.exceptions.Unreachable;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.data.Attachable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Hangable;
import org.bukkit.block.data.type.Gate;
import org.bukkit.block.data.type.Lantern;

public class MaterialAttached
extends MaterialProperty {
    public static boolean describes(MaterialTag material) {
        BlockData data = material.getModernData();
        return data instanceof Gate || data instanceof Lantern || data instanceof Attachable || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && data instanceof Hangable;
    }

    @Override
    public ElementTag getPropertyValue() {
        return new ElementTag(this.isAttached());
    }

    @Override
    public String getPropertyId() {
        return "attached";
    }

    public static void register() {
        PropertyParser.registerStaticTag(MaterialAttached.class, ElementTag.class, "attached", (attribute, prop) -> new ElementTag(prop.isAttached()), "attached_to_wall");
        PropertyParser.registerMechanism(MaterialAttached.class, ElementTag.class, "attached", (prop, mechanism, param) -> {
            if (!mechanism.requireBoolean()) {
                return;
            }
            boolean attach = param.asBoolean();
            BlockData data = prop.getBlockData();
            if (data instanceof Gate) {
                Gate gate = (Gate)data;
                gate.setInWall(attach);
            } else if (data instanceof Lantern) {
                Lantern lantern = (Lantern)data;
                lantern.setHanging(attach);
            } else if (data instanceof Attachable) {
                Attachable attachable = (Attachable)data;
                attachable.setAttached(attach);
            } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && data instanceof Hangable) {
                Hangable hangable = (Hangable)data;
                hangable.setHanging(attach);
            }
        }, "attached_to_wall");
    }

    public boolean isAttached() {
        BlockData data = this.getBlockData();
        if (data instanceof Gate) {
            Gate gate = (Gate)data;
            return gate.isInWall();
        }
        if (data instanceof Lantern) {
            Lantern lantern = (Lantern)data;
            return lantern.isHanging();
        }
        if (data instanceof Attachable) {
            Attachable attachable = (Attachable)data;
            return attachable.isAttached();
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && data instanceof Hangable) {
            Hangable hangable = (Hangable)data;
            return hangable.isHanging();
        }
        throw new Unreachable();
    }
}

