/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_19.impl;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.ProfileEditor;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.v1_19.Handler;
import com.denizenscript.denizen.nms.v1_19.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_19.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.scripts.commands.entity.RenameCommand;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ProfileEditorImpl
extends ProfileEditor {
    public static final Field ClientboundPlayerInfoUpdatePacket_entries = ReflectionHelper.getFields(xl.class).getFirstOfType(List.class);

    protected void updatePlayer(Player player, boolean isSkinChanging) {
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        UUID uuid = player.getUniqueId();
        xk removePlayerInfoPacket = new xk(List.of(uuid));
        xl addPlayerInfoPacket = xl.a(List.of(nmsPlayer));
        for (Player otherPlayer : Bukkit.getServer().getOnlinePlayers()) {
            PacketHelperImpl.send(otherPlayer, removePlayerInfoPacket);
            PacketHelperImpl.send(otherPlayer, addPlayerInfoPacket);
        }
        for (Player otherPlayer : NMSHandler.entityHelper.getPlayersThatSee((Entity)player)) {
            if (otherPlayer.getUniqueId().equals(uuid)) continue;
            PacketHelperImpl.forceRespawnPlayerEntity((Entity)player, otherPlayer);
        }
        if (isSkinChanging) {
            ((CraftServer)Bukkit.getServer()).getHandle().respawn(nmsPlayer, (WorldServer)nmsPlayer.H, true, player.getLocation(), false);
        }
        player.updateInventory();
    }

    public static boolean handleAlteredProfiles(xl packet, DenizenNetworkManagerImpl manager) {
        if (ProfileEditor.mirrorUUIDs.isEmpty() && !RenameCommand.hasAnyDynamicRenames() && fakeProfiles.isEmpty()) {
            return true;
        }
        EnumSet actions = packet.a();
        if (!actions.contains(xl.a.a) && !actions.contains(xl.a.f)) {
            return true;
        }
        try {
            boolean any2 = false;
            for (xl.b entry : packet.c()) {
                if (!ProfileEditor.mirrorUUIDs.contains(entry.a()) && !RenameCommand.customNames.containsKey(entry.a()) && !fakeProfiles.containsKey(entry.a())) continue;
                any2 = true;
                break;
            }
            if (!any2) {
                return true;
            }
            GameProfile ownProfile = manager.player.fI();
            for (xl.b data : packet.c()) {
                if (!(ProfileEditor.mirrorUUIDs.contains(data.a()) || RenameCommand.customNames.containsKey(data.a()) || fakeProfiles.containsKey(data.a()))) {
                    manager.oldManager.a((vb)ProfileEditorImpl.createInfoPacket(actions, List.of(data)));
                    continue;
                }
                String rename = RenameCommand.getCustomNameFor((UUID)data.a(), (Player)manager.player.getBukkitEntity(), (boolean)false);
                GameProfile baseProfile = fakeProfiles.containsKey(data.a()) ? ProfileEditorImpl.getGameProfile((PlayerProfile)fakeProfiles.get(data.a())) : data.b();
                GameProfile patchedProfile = new GameProfile(baseProfile.getId(), rename != null ? (rename.length() > 16 ? rename.substring(0, 16) : rename) : baseProfile.getName());
                if (ProfileEditor.mirrorUUIDs.contains(data.a())) {
                    patchedProfile.getProperties().putAll((Multimap)ownProfile.getProperties());
                } else {
                    patchedProfile.getProperties().putAll((Multimap)baseProfile.getProperties());
                }
                String listRename = RenameCommand.getCustomNameFor((UUID)data.a(), (Player)manager.player.getBukkitEntity(), (boolean)true);
                IChatBaseComponent displayName = listRename != null ? Handler.componentToNMS(FormattedTextHelper.parse((String)listRename, (ChatColor)ChatColor.WHITE)) : data.f();
                xl.b newData = new xl.b(data.a(), patchedProfile, data.c(), data.d(), data.e(), displayName, data.g());
                manager.oldManager.a((vb)ProfileEditorImpl.createInfoPacket(actions, List.of(newData)));
            }
            return false;
        }
        catch (Exception e) {
            Debug.echoError((Throwable)e);
            return true;
        }
    }

    public static xl createInfoPacket(EnumSet<xl.a> actions, List<xl.b> entries) {
        xl playerInfoUpdatePacket = new xl(actions, List.of());
        try {
            ClientboundPlayerInfoUpdatePacket_entries.set(playerInfoUpdatePacket, entries);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        return playerInfoUpdatePacket;
    }

    private static GameProfile getGameProfile(PlayerProfile playerProfile) {
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
        }
        return gameProfile;
    }
}

