/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.item.ItemProperty;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.Material;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MusicInstrumentMeta;

public class ItemInstrument
extends ItemProperty {
    public static boolean describes(ItemTag item) {
        return item.getBukkitMaterial() == Material.GOAT_HORN;
    }

    @Override
    public ElementTag getPropertyValue() {
        MusicInstrument instrument = this.getMusicInstrument();
        if (instrument != null) {
            return new ElementTag(Utilities.namespacedKeyToString(instrument.getKey()));
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "instrument";
    }

    public MusicInstrument getMusicInstrument() {
        MusicInstrumentMeta itemMeta = (MusicInstrumentMeta)this.getItemMeta();
        return itemMeta.getInstrument();
    }

    public void setMusicInstrument(MusicInstrument instrument) {
        MusicInstrumentMeta itemMeta = (MusicInstrumentMeta)this.getItemMeta();
        itemMeta.setInstrument(instrument);
        this.setItemMeta((ItemMeta)itemMeta);
    }

    public static void register() {
        PropertyParser.registerTag(ItemInstrument.class, ElementTag.class, "instrument", (attribute, prop) -> {
            MusicInstrument musicInstrument = prop.getMusicInstrument();
            if (musicInstrument == null) {
                return null;
            }
            return new ElementTag(Utilities.namespacedKeyToString(musicInstrument.getKey()));
        }, new String[0]);
        PropertyParser.registerMechanism(ItemInstrument.class, ElementTag.class, "instrument", (prop, mechanism, param) -> {
            MusicInstrument instrument = MusicInstrument.getByKey((NamespacedKey)Utilities.parseNamespacedKey(param.asString()));
            if (instrument == null) {
                mechanism.echoError("Invalid horn instrument: '" + param.asString() + "'! Instrument names should be like this: 'seek_goat_horn'.");
                return;
            }
            prop.setMusicInstrument(MusicInstrument.getByKey((NamespacedKey)Utilities.parseNamespacedKey(param.asString())));
        }, new String[0]);
    }
}

