/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class LookCommand
extends AbstractCommand {
    public static HashMap<UUID, BukkitTask> lookTasks = new HashMap();

    public LookCommand() {
        this.setName("look");
        this.setSyntax("look (<entity>|...) [<location>/cancel/yaw:<yaw> pitch:<pitch>] (duration:<duration>) (offthread_repeat:<#>)");
        this.setRequiredArguments(1, 5);
        this.isProcedural = false;
        this.addRemappedPrefixes("duration", "d");
        this.autoCompile();
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="entities") @ArgDefaultNull @ArgLinear ObjectTag entitiesObj, @ArgName(value="location") @ArgDefaultNull @ArgLinear ObjectTag locationObj, final @ArgName(value="duration") @ArgDefaultNull @ArgPrefixed DurationTag duration, @ArgName(value="yaw") @ArgDefaultNull @ArgPrefixed ElementTag yaw, @ArgName(value="pitch") @ArgDefaultNull @ArgPrefixed ElementTag pitch, @ArgName(value="offthread_repeat") @ArgDefaultNull @ArgPrefixed ElementTag offthreadRepeats) {
        LocationTag loc;
        String entStr;
        if (!(entitiesObj instanceof ListTag) && ((entStr = entitiesObj.asElement().asLowerString()).equals("cancel") || entStr.startsWith("l@"))) {
            Deprecations.outOfOrderArgs.warn(scriptEntry);
            ObjectTag swap = entitiesObj;
            entitiesObj = locationObj;
            locationObj = swap;
        }
        List<EntityTag> entities = entitiesObj.asType(ListTag.class, scriptEntry.context).filter(EntityTag.class, scriptEntry);
        for (EntityTag entity : entities) {
            BukkitTask task;
            if (!entity.isSpawned() || (task = lookTasks.remove(entity.getUUID())) == null) continue;
            task.cancel();
        }
        if (locationObj != null && !(locationObj instanceof LocationTag) && locationObj.asElement().asLowerString().equals("cancel")) {
            return;
        }
        LocationTag locationTag = loc = locationObj == null ? null : locationObj.asType(LocationTag.class, scriptEntry.context);
        if (loc == null && yaw == null && pitch == null) {
            throw new InvalidArgumentsRuntimeException("Missing or invalid Location input!");
        }
        final float yawRaw = yaw == null ? 0.0f : yaw.asFloat();
        final float pitchRaw = pitch == null ? 0.0f : pitch.asFloat();
        for (final EntityTag entity : entities) {
            if (!entity.isSpawned()) continue;
            if (loc != null) {
                NMSHandler.entityHelper.faceLocation(entity.getBukkitEntity(), (Location)loc);
                continue;
            }
            if (entity.isPlayer()) {
                LocationTag playerTeleDest = entity.getLocation().clone();
                float relYaw = (yawRaw - playerTeleDest.getYaw()) % 360.0f;
                if (relYaw > 180.0f) {
                    relYaw -= 360.0f;
                }
                float actualRelYaw = relYaw;
                float relPitch = pitchRaw - playerTeleDest.getPitch();
                playerTeleDest.setYaw(yawRaw);
                playerTeleDest.setPitch(pitchRaw);
                Player player = entity.getPlayer();
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19)) {
                    NetworkInterceptHelper.enable();
                    NMSHandler.packetHelper.sendRelativeLookPacket(player, actualRelYaw, relPitch);
                } else {
                    PaperAPITools.instance.teleportPlayerRelative(player, playerTeleDest);
                }
                if (offthreadRepeats == null) continue;
                NetworkInterceptHelper.enable();
                int times = offthreadRepeats.asInt();
                int ms = 50 / (times + 1);
                DenizenCore.runAsync(() -> {
                    try {
                        for (int i = 0; i < times; ++i) {
                            Thread.sleep(ms);
                            NMSHandler.packetHelper.sendRelativeLookPacket(player, actualRelYaw, relPitch);
                        }
                    }
                    catch (Throwable ex) {
                        Debug.echoError(ex);
                    }
                });
                continue;
            }
            NMSHandler.entityHelper.rotate(entity.getBukkitEntity(), yawRaw, pitchRaw);
        }
        if (duration != null && duration.getTicks() > 1L) {
            for (final EntityTag entity : entities) {
                BukkitRunnable task = new BukkitRunnable(){
                    long bounces = 0L;

                    public void run() {
                        ++this.bounces;
                        if (this.bounces > duration.getTicks()) {
                            this.cancel();
                            lookTasks.remove(entity.getUUID());
                            return;
                        }
                        if (entity.isSpawned()) {
                            if (loc != null) {
                                NMSHandler.entityHelper.faceLocation(entity.getBukkitEntity(), (Location)loc);
                            } else {
                                NMSHandler.entityHelper.rotate(entity.getBukkitEntity(), yawRaw, pitchRaw);
                            }
                        }
                    }
                };
                BukkitTask newTask = task.runTaskTimer((Plugin)Denizen.getInstance(), 0L, 1L);
                lookTasks.put(entity.getUUID(), newTask);
            }
        }
    }
}

