/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import io.papermc.paper.event.entity.WardenAngerChangeEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class WardenChangesAngerLevelScriptEvent
extends BukkitScriptEvent
implements Listener {
    public WardenAngerChangeEvent event;

    public WardenChangesAngerLevelScriptEvent() {
        this.registerCouldMatcher("warden changes anger level");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.event.getEntity().getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "entity" -> new EntityTag((Entity)this.event.getEntity());
            case "new_anger" -> new ElementTag(this.event.getNewAnger());
            case "old_anger" -> new ElementTag(this.event.getOldAnger());
            case "target" -> {
                if (this.event.getTarget() != null) {
                    yield new EntityTag(this.event.getTarget());
                }
                yield null;
            }
            default -> super.getContext(name);
        };
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        ElementTag value;
        String lower;
        if (determinationObj instanceof ElementTag && (lower = CoreUtilities.toLowerCase(determinationObj.toString())).startsWith("anger:") && (value = new ElementTag(lower.substring("anger:".length()))).isInt()) {
            this.event.setNewAnger(value.asInt());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.event.getTarget());
    }

    @EventHandler
    public void onWardenAngerChange(WardenAngerChangeEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

