/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.entity.EntityAttachmentHelper;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.scripts.commands.generator.ArgSubType;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;

public class AttachCommand
extends AbstractCommand {
    public AttachCommand() {
        this.setName("attach");
        this.setSyntax("attach [<entity>|...] [to:<entity>/cancel] (offset:<offset>) (relative) (yaw_offset:<#.#>) (pitch_offset:<#.#>) (sync_server) (no_rotate/no_pitch) (for:<player>|...)");
        this.setRequiredArguments(2, 9);
        this.isProcedural = false;
        this.autoCompile();
    }

    public static void autoExecute(@ArgName(value="entities") @ArgLinear @ArgSubType(value=EntityTag.class) List<EntityTag> entities, @ArgName(value="to") @ArgPrefixed @ArgDefaultNull EntityTag target, @ArgName(value="cancel") boolean cancel, @ArgName(value="offset") @ArgPrefixed @ArgDefaultNull LocationTag offset, @ArgName(value="relative") boolean relative, @ArgName(value="yaw_offset") @ArgPrefixed @ArgDefaultText(value="0") float yawOffset, @ArgName(value="pitch_offset") @ArgPrefixed @ArgDefaultText(value="0") float pitchOffset, @ArgName(value="sync_server") boolean syncServer, @ArgName(value="no_rotate") boolean noRotate, @ArgName(value="no_pitch") boolean noPitch, @ArgName(value="for") @ArgPrefixed @ArgDefaultNull @ArgSubType(value=PlayerTag.class) List<PlayerTag> forPlayers) {
        if (target == null && !cancel) {
            throw new InvalidArgumentsRuntimeException("Must specify a target entity, or 'cancel'!");
        }
        BiConsumer<EntityTag, UUID> procPlayer = (entity, player) -> {
            if (cancel) {
                EntityAttachmentHelper.removeAttachment(entity.getUUID(), player);
            } else {
                EntityAttachmentHelper.AttachmentData attachment = new EntityAttachmentHelper.AttachmentData();
                attachment.attached = entity;
                attachment.to = target;
                attachment.positionalOffset = offset == null ? null : offset.clone();
                attachment.offsetRelative = relative;
                attachment.yawAngleOffset = yawOffset;
                attachment.pitchAngleOffset = pitchOffset;
                attachment.syncServer = syncServer;
                attachment.forPlayer = player;
                attachment.noRotate = noRotate;
                attachment.noPitch = noPitch;
                EntityAttachmentHelper.registerAttachment(attachment);
            }
        };
        for (EntityTag entity2 : entities) {
            if (!(entity2.isSpawned() || entity2.isFake || cancel)) {
                Debug.echoError("Cannot attach entity '" + entity2 + "': entity is not spawned.");
                continue;
            }
            if (forPlayers == null || forPlayers.isEmpty() && syncServer) {
                procPlayer.accept(entity2, null);
                continue;
            }
            for (PlayerTag player2 : forPlayers) {
                procPlayer.accept(entity2, player2.getUUID());
            }
        }
    }
}

