/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.npc.traits;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.FishingHelper;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.util.PlayerAnimation;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class FishingTrait
extends Trait {
    @Persist(value="fishing")
    public boolean fishing = false;
    @Persist(value="catch type")
    public FishingHelper.CatchType catchType = FishingHelper.CatchType.NONE;
    @Persist(value="fishing spot")
    public Location fishingLocation = null;
    public FishHook fishHook = null;
    public Item fish = null;
    @Persist(value="catch chance")
    public int catchPercent = 65;
    @Persist(value="reel tick rate")
    public int reelTickRate = 400;
    @Persist(value="cast tick rate")
    public int castTickRate = 75;
    int reelCount = 100;
    int castCount = 0;
    public boolean isCast = false;

    public void onSpawn() {
        this.isCast = false;
    }

    public void run() {
        if (this.fish != null && this.fish.getLocation().distance(this.npc.getStoredLocation()) < 3.0) {
            try {
                this.fish.remove();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.fishing) {
            this.isCast = false;
            return;
        }
        if (this.isCast) {
            ++this.reelCount;
            if (this.reelCount >= this.reelTickRate) {
                this.reel();
                this.reelCount = 0;
                this.castCount = 0;
            }
        } else {
            ++this.castCount;
            if (this.castCount >= this.castTickRate) {
                this.cast();
                this.castCount = 0;
            }
        }
    }

    public void startFishing(Location location) {
        new NPCTag(this.npc).action("start fishing", null);
        this.fishingLocation = location.clone();
        this.cast();
        this.fishing = true;
    }

    public void stopFishing() {
        new NPCTag(this.npc).action("stop fishing", null);
        this.reel();
        this.reelCount = 100;
        this.castCount = 0;
        this.fishingLocation = null;
        this.fishing = false;
    }

    public boolean scanForFishSpot(Location near, boolean horizontal) {
        Block block = near.getBlock();
        if (block.getType() == Material.WATER) {
            this.fishingLocation = near.clone();
            return true;
        }
        if (block.getRelative(BlockFace.DOWN).getType() == Material.WATER) {
            this.fishingLocation = near.clone().add(0.0, -1.0, 0.0);
            return true;
        }
        if (block.getRelative(BlockFace.DOWN).getRelative(BlockFace.DOWN).getType() == Material.WATER) {
            this.fishingLocation = near.clone().add(0.0, -2.0, 0.0);
            return true;
        }
        if (horizontal) {
            return this.scanForFishSpot(near.clone().add(1.0, 0.0, 0.0), false) || this.scanForFishSpot(near.clone().add(-1.0, 0.0, 0.0), false) || this.scanForFishSpot(near.clone().add(0.0, 0.0, 1.0), false) || this.scanForFishSpot(near.clone().add(0.0, 0.0, -1.0), false);
        }
        return false;
    }

    public void startFishing() {
        this.fishing = true;
        Location search = this.npc.getStoredLocation().clone();
        Vector direction = this.npc.getStoredLocation().getDirection().clone();
        if (direction.getY() > -0.1) {
            direction.setY(-0.1);
        }
        for (int i = 0; i < 10; ++i) {
            search.add(direction.clone());
            if (this.scanForFishSpot(search, true)) break;
        }
    }

    private void cast() {
        Vector test;
        double elev;
        Location to;
        new NPCTag(this.npc).action("cast fishing rod", null);
        if (this.fishingLocation == null) {
            Debug.echoError("Fishing location not found!");
            return;
        }
        this.isCast = true;
        double v = 34.0;
        double g = 20.0;
        Location from = this.npc.getStoredLocation();
        Double testAngle = FishingTrait.launchAngle(from = from.add(0.0, 0.33, 0.0), to = this.fishingLocation, v, elev = (test = to.clone().subtract(from).toVector()).getY(), g);
        if (testAngle == null) {
            return;
        }
        double hangtime = FishingTrait.hangtime(testAngle, v, elev, g);
        Vector victor = to.clone().subtract(from).toVector();
        double dist = Math.sqrt(Math.pow(victor.getX(), 2.0) + Math.pow(victor.getZ(), 2.0));
        elev = victor.getY();
        if (dist == 0.0) {
            return;
        }
        Double launchAngle = FishingTrait.launchAngle(from, to, v, elev, g);
        if (launchAngle == null) {
            return;
        }
        victor.setY(Math.tan(launchAngle) * dist);
        victor = FishingTrait.normalizeVector(victor);
        v += 0.5 * Math.pow(hangtime, 2.0);
        victor = victor.multiply((v += (CoreUtilities.getRandom().nextDouble() - 0.8) / 2.0) / 20.0);
        if (this.npc.getEntity() instanceof Player) {
            this.fishHook = NMSHandler.fishingHelper.spawnHook(from, (Player)this.npc.getEntity());
            this.fishHook.setShooter((ProjectileSource)this.npc.getEntity());
            this.fishHook.setVelocity(victor);
            PlayerAnimation.ARM_SWING.play((Player)this.npc.getEntity());
        }
    }

    private void reel() {
        this.isCast = false;
        new NPCTag(this.npc).action("reel in fishing rod", null);
        int chance = (int)(Math.random() * 100.0);
        if (this.catchPercent > chance && this.fishHook != null && this.catchType != FishingHelper.CatchType.NONE) {
            try {
                this.fish.remove();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Location location = this.fishHook.getLocation();
            ItemStack result = NMSHandler.fishingHelper.getResult(this.fishHook, this.catchType);
            if (result != null) {
                this.fish = location.getWorld().dropItem(location, result);
                Location npcLocation = this.npc.getStoredLocation();
                double d5 = npcLocation.getX() - location.getX();
                double d6 = npcLocation.getY() - location.getY();
                double d7 = npcLocation.getZ() - location.getZ();
                double d8 = Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7);
                double d9 = 0.1;
                this.fish.setVelocity(new Vector(d5 * d9, d6 * d9 + Math.sqrt(d8) * 0.08, d7 * d9));
            }
            new NPCTag(this.npc).action("catch fish", null);
        }
        if (this.fishHook != null && this.fishHook.isValid()) {
            this.fishHook.remove();
            this.fishHook = null;
        }
        if (this.npc.getEntity() instanceof Player) {
            PlayerAnimation.ARM_SWING.play((Player)this.npc.getEntity());
        }
    }

    public boolean isFishing() {
        return this.fishing;
    }

    public FishingTrait() {
        super("fishing");
    }

    public static Double launchAngle(Location from, Location to, double v, double elev, double g) {
        double derp;
        Vector victor = from.clone().subtract(to).toVector();
        double dist = Math.sqrt(Math.pow(victor.getX(), 2.0) + Math.pow(victor.getZ(), 2.0));
        double v2 = Math.pow(v, 2.0);
        double v4 = Math.pow(v, 4.0);
        if (v4 < (derp = g * (g * Math.pow(dist, 2.0) + 2.0 * elev * v2))) {
            return null;
        }
        return Math.atan((v2 - Math.sqrt(v4 - derp)) / (g * dist));
    }

    public static double hangtime(double launchAngle, double v, double elev, double g) {
        double a = v * Math.sin(launchAngle);
        double b = -2.0 * g * elev;
        if (Math.pow(a, 2.0) + b < 0.0) {
            return 0.0;
        }
        return (a + Math.sqrt(Math.pow(a, 2.0) + b)) / g;
    }

    public static Vector normalizeVector(Vector victor) {
        double mag = Math.sqrt(Math.pow(victor.getX(), 2.0) + Math.pow(victor.getY(), 2.0) + Math.pow(victor.getZ(), 2.0));
        if (mag != 0.0) {
            return victor.multiply(1.0 / mag);
        }
        return victor.multiply(0);
    }

    public void setCatchType(FishingHelper.CatchType catchType) {
        this.catchType = catchType;
    }

    public void setCatchPercent(int catchPercent) {
        this.catchPercent = catchPercent;
    }
}

