/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.debugging;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.DebugSubmitter;
import java.lang.invoke.StringConcatFactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DebugSubmit {
    @Deprecated
    public static List<Supplier<String>> additionalDebugLines = new ArrayList<Supplier<String>>();
    public static YamlConfiguration paperConfig;

    public static void init() {
        DebugSubmitter.pasteTitleGetter = () -> "Denizen Debug Logs From " + ChatColor.stripColor((String)Bukkit.getServer().getMotd());
        DebugSubmitter.debugHeaderLines.add(DebugSubmit::getCoreHeader);
        DebugSubmitter.debugHeaderLines.addAll(additionalDebugLines);
        additionalDebugLines.clear();
    }

    public static String getCoreHeader() {
        if (!DebugSubmitter.debugHeaderLines.isEmpty()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.instance, () -> {
                DebugSubmitter.debugHeaderLines.addAll(additionalDebugLines);
                additionalDebugLines.clear();
            }, 0L);
        }
        try {
            String paperMode;
            Object temp;
            StringBuilder pluginlist = new StringBuilder();
            int newlineLength = 0;
            int pluginCount = Bukkit.getPluginManager().getPlugins().length;
            for (Plugin pl : Bukkit.getPluginManager().getPlugins()) {
                temp = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0002\u0001\u0001: \u0001, ", "\u0001"}, (String)(pl.isEnabled() ? "2" : "4"), pl.getName(), pl.getDescription().getVersion());
                pluginlist.append((String)temp);
                if ((newlineLength += ((String)temp).length()) <= 80) continue;
                newlineLength = 0;
                pluginlist.append("\n");
            }
            StringBuilder worldlist = new StringBuilder();
            newlineLength = 0;
            int worldCount = Bukkit.getWorlds().size();
            for (World w : Bukkit.getWorlds()) {
                temp = w.getName() + ", ";
                worldlist.append((String)temp);
                if ((newlineLength += ((String)temp).length()) <= 80) continue;
                newlineLength = 0;
                worldlist.append("\n");
            }
            StringBuilder playerlist = new StringBuilder();
            newlineLength = 0;
            int playerCount = Bukkit.getOnlinePlayers().size();
            for (Player pla : Bukkit.getOnlinePlayers()) {
                String temp2 = pla.getDisplayName() + ChatColor.GRAY + "(" + pla.getName() + "), ";
                playerlist.append(temp2);
                if ((newlineLength += temp2.length()) <= 80) continue;
                newlineLength = 0;
                playerlist.append("\n");
            }
            if (playerlist.length() < 2) {
                playerlist.append("No Online Players, ");
            }
            int plNormal = 0;
            int plNull = 0;
            int pl3 = 0;
            int pl0 = 0;
            int plWeird = 0;
            try {
                for (UUID id : PlayerTag.getAllPlayers().values()) {
                    if (id == null) {
                        ++plNull;
                        continue;
                    }
                    if (id.version() == 4) {
                        ++plNormal;
                        continue;
                    }
                    if (id.version() == 3) {
                        ++pl3;
                        continue;
                    }
                    if (id.version() == 0) {
                        ++pl0;
                        continue;
                    }
                    ++plWeird;
                }
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
            Object playerSet = (String)(plNormal > 0 ? plNormal + " normal, " : "") + (String)(plNull > 0 ? plNull + " null, " : "") + (String)(pl3 > 0 ? pl3 + " v3, " : "") + (String)(pl0 > 0 ? pl0 + " v0, " : "") + (String)(plWeird > 0 ? plWeird + " other, " : "");
            if (((String)playerSet).length() > 2) {
                playerSet = ((String)playerSet).substring(0, ((String)playerSet).length() - 2);
            }
            boolean proxied = false;
            String modeSuffix = "";
            if (Bukkit.getServer().spigot().getConfig().getBoolean("settings.bungeecord")) {
                modeSuffix = " (BungeeCord)";
                proxied = true;
            } else if (Denizen.supportsPaper && (paperMode = DebugSubmit.getPaperOnlineMode()) != null) {
                modeSuffix = paperMode;
                proxied = true;
            }
            String onlineMode = (Bukkit.getServer().getOnlineMode() ? ChatColor.GREEN + "online" : (proxied ? ChatColor.YELLOW : ChatColor.RED) + "offline") + modeSuffix;
            return "Server Version: " + Bukkit.getServer().getName() + " version " + Bukkit.getServer().getVersion() + "\nActive Plugins (" + pluginCount + "): " + pluginlist.substring(0, pluginlist.length() - 2) + "\nLoaded Worlds (" + worldCount + "): " + worldlist.substring(0, worldlist.length() - 2) + "\nOnline Players (" + playerCount + "): " + playerlist.substring(0, playerlist.length() - 2) + "\nTotal Players Ever: " + PlayerTag.getAllPlayers().size() + " (" + (String)playerSet + ")\nMode: " + onlineMode;
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return "(Error Building Header)";
        }
    }

    public static String getPaperOnlineMode() {
        boolean isOnline;
        boolean isEnabled;
        try {
            Class<?> config = Class.forName("io.papermc.paper.configuration.GlobalConfiguration");
            Object instance = ReflectionHelper.getFieldValue(config, "instance", null);
            Object proxies = ReflectionHelper.getFieldValue(config, "proxies", instance);
            Object velocity = ReflectionHelper.getFieldValue(proxies.getClass(), "velocity", proxies);
            Field velField = ReflectionHelper.getFields(velocity.getClass()).get("enabled");
            velField.setAccessible(true);
            isEnabled = velField.getBoolean(velocity);
            Field onlineField = ReflectionHelper.getFields(velocity.getClass()).get("onlineMode");
            onlineField.setAccessible(true);
            isOnline = onlineField.getBoolean(velocity);
        }
        catch (ClassNotFoundException ignore) {
            isEnabled = DebugSubmit.getPaperConfigKey("settings.velocity-support.enabled");
            isOnline = DebugSubmit.getPaperConfigKey("settings.velocity-support.online-mode");
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return null;
        }
        if (isEnabled) {
            return isOnline ? ChatColor.GREEN + " (Velocity: online)" : ChatColor.RED + " (Velocity: offline)";
        }
        return null;
    }

    public static boolean getPaperConfigKey(String key) {
        if (!Denizen.supportsPaper) {
            return false;
        }
        try {
            if (paperConfig == null) {
                paperConfig = (YamlConfiguration)ReflectionHelper.getFields(Class.forName("com.destroystokyo.paper.PaperConfig")).get("config").get(null);
            }
            return paperConfig.getBoolean(key);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return false;
        }
    }
}

