/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.Collections;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;

public class TradeTag
implements ObjectTag,
Adjustable {
    private MerchantRecipe recipe;
    public static ObjectTagProcessor<TradeTag> tagProcessor = new ObjectTagProcessor();

    @Fetchable(value="trade")
    public static TradeTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        if (ObjectFetcher.isObjectWithProperties(string)) {
            return ObjectFetcher.getObjectFromWithProperties(TradeTag.class, string, context);
        }
        if ((string = CoreUtilities.toLowerCase(string).replace("trade@", "")).toLowerCase().matches("trade")) {
            return new TradeTag(null);
        }
        return null;
    }

    public static boolean matches(String str) {
        return TradeTag.valueOf(str, CoreUtilities.noDebugContext) != null;
    }

    public TradeTag(MerchantRecipe recipe) {
        if (recipe == null) {
            recipe = new MerchantRecipe(new ItemStack(Material.AIR), 0);
            recipe.setIngredients(Collections.singletonList(new ItemStack(Material.AIR)));
        }
        this.recipe = recipe;
    }

    public static MerchantRecipe duplicateRecipe(MerchantRecipe oldRecipe) {
        return TradeTag.duplicateRecipe(oldRecipe.getResult(), oldRecipe);
    }

    public static MerchantRecipe duplicateRecipe(ItemStack result, MerchantRecipe oldRecipe) {
        MerchantRecipe newRecipe = NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18) ? new MerchantRecipe(result, oldRecipe.getUses(), oldRecipe.getMaxUses(), oldRecipe.hasExperienceReward(), oldRecipe.getVillagerExperience(), oldRecipe.getPriceMultiplier(), oldRecipe.getDemand(), oldRecipe.getSpecialPrice()) : new MerchantRecipe(result, oldRecipe.getUses(), oldRecipe.getMaxUses(), oldRecipe.hasExperienceReward(), oldRecipe.getVillagerExperience(), oldRecipe.getPriceMultiplier());
        newRecipe.setIngredients(oldRecipe.getIngredients());
        return newRecipe;
    }

    @Override
    public TradeTag duplicate() {
        MerchantRecipe result = TradeTag.duplicateRecipe(this.recipe);
        return new TradeTag(result);
    }

    public String toString() {
        return this.identify();
    }

    public MerchantRecipe getRecipe() {
        return this.recipe;
    }

    public void setRecipe(MerchantRecipe recipe) {
        this.recipe = recipe;
    }

    @Override
    public String getPrefix() {
        return "trade";
    }

    @Override
    public TradeTag setPrefix(String prefix) {
        return this;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String debuggable() {
        return "<LG>trade@trade<Y>" + PropertyParser.getPropertiesDebuggable(this);
    }

    @Override
    public String identify() {
        return "trade@trade" + PropertyParser.getPropertiesString(this);
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    @Override
    public Object getJavaObject() {
        return this.recipe;
    }

    public static void register() {
        PropertyParser.registerPropertyTagHandlers(TradeTag.class, tagProcessor);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        this.adjust(mechanism);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        tagProcessor.processMechanism(this, mechanism);
    }
}

