/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_17.helpers;

import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.IntArrayTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_17.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_17.helpers.BlockHelperImpl;
import com.denizenscript.denizen.nms.v1_17.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.libs.it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import org.bukkit.craftbukkit.v1_17_R1.CraftServer;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftNamespacedKey;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;

public class ItemHelperImpl
extends ItemHelper {
    public static bti<?> getNMSRecipe(NamespacedKey key) {
        ww nmsKey = CraftNamespacedKey.toMinecraft((NamespacedKey)key);
        for (Object2ObjectLinkedOpenHashMap recipeMap : ((CraftServer)Bukkit.getServer()).getServer().aD().c.values()) {
            bti recipe = (bti)recipeMap.get((Object)nmsKey);
            if (recipe == null) continue;
            return recipe;
        }
        return null;
    }

    public void setMaxStackSize(Material material, int size) {
        try {
            ReflectionHelper.getFinalSetter(Material.class, (String)"maxStack").invoke(material, size);
            ReflectionHelper.getFinalSetter(bqm.class, (String)ReflectionMappingsInfo.Item_maxStackSize).invoke((bqm)gw.Z.a(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())), size);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public Integer burnTime(Material material) {
        return (Integer)cig.f().get(CraftMagicNumbers.getItem((Material)material));
    }

    public void clearDenizenRecipes() {
        for (Object2ObjectLinkedOpenHashMap recipeMap : ((CraftServer)Bukkit.getServer()).getServer().aD().c.values()) {
            for (ww key : new ArrayList(recipeMap.keySet())) {
                if (!key.b().equalsIgnoreCase("denizen")) continue;
                recipeMap.remove((Object)key);
            }
        }
    }

    public void setShapedRecipeIngredient(ShapedRecipe recipe, char c2, ItemStack[] item, boolean exact) {
        if (item.length == 1 && item[0].getType() == Material.AIR) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(Material.AIR));
        } else if (exact) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.ExactChoice(item));
        } else {
            Material[] mats = new Material[item.length];
            for (int i = 0; i < item.length; ++i) {
                mats[i] = item[i].getType();
            }
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(mats));
        }
    }

    public static btf itemArrayToRecipe(ItemStack[] items, boolean exact) {
        btf.a[] stacks = new btf.a[items.length];
        for (int i = 0; i < items.length; ++i) {
            stacks[i] = new btf.a(CraftItemStack.asNMSCopy((ItemStack)items[i]));
        }
        btf itemRecipe = new btf(Arrays.stream(stacks));
        itemRecipe.exact = exact;
        return itemRecipe;
    }

    public void registerFurnaceRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, float exp, int time, String type, boolean exact, String category) {
        ww key = new ww("denizen", keyName);
        btf itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        Object recipe = type.equalsIgnoreCase("smoker") ? new btv(key, group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("blast") ? new bsx(key, group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("campfire") ? new bsz(key, group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : new btu(key, group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time)));
        ((CraftServer)Bukkit.getServer()).getServer().aD().addRecipe((bti)recipe);
    }

    public void registerStonecuttingRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, boolean exact) {
        ww key = new ww("denizen", keyName);
        btf itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        btw recipe = new btw(key, group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result));
        ((CraftServer)Bukkit.getServer()).getServer().aD().addRecipe((bti)recipe);
    }

    public void registerSmithingRecipe(String keyName, ItemStack result, ItemStack[] baseItem, boolean baseExact, ItemStack[] upgradeItem, boolean upgradeExact) {
        ww key = new ww("denizen", keyName);
        btf baseItemRecipe = ItemHelperImpl.itemArrayToRecipe(baseItem, baseExact);
        btf upgradeItemRecipe = ItemHelperImpl.itemArrayToRecipe(upgradeItem, upgradeExact);
        btz recipe = new btz(key, baseItemRecipe, upgradeItemRecipe, CraftItemStack.asNMSCopy((ItemStack)result));
        ((CraftServer)Bukkit.getServer()).getServer().aD().addRecipe((bti)recipe);
    }

    public void registerShapelessRecipe(String keyName, String group, ItemStack result, List<ItemStack[]> ingredients, boolean[] exact, String category) {
        ww key = new ww("denizen", keyName);
        ArrayList<btf> ingredientList = new ArrayList<btf>();
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredientList.add(ItemHelperImpl.itemArrayToRecipe(ingredients.get(i), exact[i]));
        }
        bto recipe = new bto(key, group, CraftItemStack.asNMSCopy((ItemStack)result), gs.a(null, (Object[])ingredientList.toArray(new btf[0])));
        ((CraftServer)Bukkit.getServer()).getServer().aD().addRecipe((bti)recipe);
    }

    public String getJsonString(ItemStack itemStack) {
        String json = CraftItemStack.asNMSCopy((ItemStack)itemStack).G().c().toString().replace("\\", "\\\\").replace("\"", "\\\"");
        return json.substring(176, json.length() - 185);
    }

    public String getRawHoverText(ItemStack itemStack) {
        na tag = CraftItemStack.asNMSCopy((ItemStack)itemStack).s();
        if (tag == null) {
            return null;
        }
        return tag.toString();
    }

    public PlayerProfile getSkullSkin(ItemStack is) {
        GameProfile profile;
        na tag;
        bqq itemStack = CraftItemStack.asNMSCopy((ItemStack)is);
        if (itemStack.r() && (tag = itemStack.s()).b("SkullOwner", 10) && (profile = nm.a((na)tag.p("SkullOwner"))) != null) {
            Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
            return new PlayerProfile(profile.getName(), profile.getId(), property != null ? property.getValue() : null, property != null ? property.getSignature() : null);
        }
        return null;
    }

    public ItemStack setSkullSkin(ItemStack itemStack, PlayerProfile playerProfile) {
        bqq nmsItemStack;
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().get((Object)"textures").clear();
            if (playerProfile.getTextureSignature() != null) {
                gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
            } else {
                gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture()));
            }
        }
        na tag = (nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack)).r() ? nmsItemStack.s() : new na();
        tag.a("SkullOwner", (ns)nm.a((na)new na(), (GameProfile)gameProfile));
        nmsItemStack.c(tag);
        return CraftItemStack.asBukkitCopy((bqq)nmsItemStack);
    }

    public ItemStack addNbtData(ItemStack itemStack, String key, Tag value) {
        bqq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        na tag = nmsItemStack.r() ? nmsItemStack.s() : new na();
        CompoundTag compound = CompoundTagImpl.fromNMSTag(tag).createBuilder().put(key, value).build();
        nmsItemStack.c(((CompoundTagImpl)compound).toNMSTag());
        return CraftItemStack.asBukkitCopy((bqq)nmsItemStack);
    }

    public CompoundTag getNbtData(ItemStack itemStack) {
        bqq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (nmsItemStack != null && nmsItemStack.r()) {
            return CompoundTagImpl.fromNMSTag(nmsItemStack.s());
        }
        return new CompoundTagImpl(new HashMap<String, Tag>());
    }

    public ItemStack setNbtData(ItemStack itemStack, CompoundTag compoundTag) {
        bqq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.c(((CompoundTagImpl)compoundTag).toNMSTag());
        return CraftItemStack.asBukkitCopy((bqq)nmsItemStack);
    }

    public void setInventoryItem(Inventory inventory, ItemStack item, int slot) {
        if (inventory instanceof CraftInventoryPlayer && ((CraftInventoryPlayer)inventory).getInventory().l == null) {
            ((CraftInventoryPlayer)inventory).getInventory().a(slot, CraftItemStack.asNMSCopy((ItemStack)item));
        } else {
            inventory.setItem(slot, item);
        }
    }

    public IntArrayTag convertUuidToNbt(UUID id) {
        return new IntArrayTag(nm.a((UUID)id).f());
    }

    public UUID convertNbtToUuid(IntArrayTag id) {
        return nm.a((ns)new ne(id.getValue()));
    }

    public String getDisplayName(ItemTag item) {
        if (!item.getItemMeta().hasDisplayName()) {
            return null;
        }
        bqq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        String jsonText = ((na)nmsItemStack.s().c("display")).l("Name");
        BaseComponent[] nameComponent = ComponentSerializer.parse((String)jsonText);
        return FormattedTextHelper.stringify((BaseComponent[])nameComponent);
    }

    public List<String> getLore(ItemTag item) {
        if (!item.getItemMeta().hasLore()) {
            return null;
        }
        bqq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        ng list = ((na)nmsItemStack.s().c("display")).c("Lore", 8);
        ArrayList<String> outList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            BaseComponent[] lineComponent = ComponentSerializer.parse((String)list.j(i));
            outList.add(FormattedTextHelper.stringify((BaseComponent[])lineComponent));
        }
        return outList;
    }

    public void setDisplayName(ItemTag item, String name) {
        bqq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        na tag = nmsItemStack.t();
        na display = tag.p("display");
        if (!tag.e("display")) {
            tag.a("display", (ns)display);
        }
        if (name == null || name.isEmpty()) {
            display.a("Name", null);
            return;
        }
        BaseComponent[] components = FormattedTextHelper.parse((String)name, (ChatColor)ChatColor.WHITE);
        display.a("Name", (ns)nq.a((String)ComponentSerializer.toString((BaseComponent[])components)));
        item.setItemStack(CraftItemStack.asBukkitCopy((bqq)nmsItemStack));
    }

    public void setLore(ItemTag item, List<String> lore) {
        bqq nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        na tag = nmsItemStack.t();
        na display = tag.p("display");
        if (!tag.e("display")) {
            tag.a("display", (ns)display);
        }
        if (lore == null || lore.isEmpty()) {
            display.a("Lore", null);
        } else {
            ng tagList = new ng();
            for (String line : lore) {
                tagList.add((Object)nq.a((String)ComponentSerializer.toString((BaseComponent[])FormattedTextHelper.parse((String)line, (ChatColor)ChatColor.WHITE))));
            }
            display.a("Lore", (ns)tagList);
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((bqq)nmsItemStack));
    }

    public static ckt getCorrectStateForFluidBlock(bwq world, ckt iblockdata, gg blockposition) {
        try {
            Object fluid = BlockHelperImpl.BLOCKSTATEBASE_GETFLUIDSTATE.invoke(iblockdata);
            boolean isEmpty = BlockHelperImpl.FLUIDSTATE_ISEMPTY.invoke(fluid);
            if (!isEmpty && !iblockdata.d((bvu)world, blockposition, gl.b)) {
                return BlockHelperImpl.FLUIDSTATE_CREATELEGACYBLOCK.invoke(fluid);
            }
            return iblockdata;
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return iblockdata;
        }
    }

    public static boolean blockStateFluidIsEmpty(ckt iblockdata) {
        try {
            Object fluid = BlockHelperImpl.BLOCKSTATEBASE_GETFLUIDSTATE.invoke(iblockdata);
            return BlockHelperImpl.FLUIDSTATE_ISEMPTY.invoke(fluid);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return false;
        }
    }

    public static void renderFullMap(dhs worldmap, int xMin, int zMin, int xMax, int zMax) {
        abr world = ((CraftWorld)worldmap.mapView.getWorld()).getHandle();
        int scale = 1 << worldmap.f;
        int mapX = worldmap.c;
        int mapZ = worldmap.d;
        for (int x = xMin; x < xMax; ++x) {
            double d0 = 0.0;
            for (int z = zMin; z < zMax; ++z) {
                dex materialmapcolor;
                int k2 = (mapX / scale + x - 64) * scale;
                int l2 = (mapZ / scale + z - 64) * scale;
                LinkedHashMultiset multiset = LinkedHashMultiset.create();
                cmx chunk = world.m(new gg(k2, 0, l2));
                if (chunk.u()) continue;
                bvv chunkcoordintpair = chunk.f();
                int i3 = k2 & 0xF;
                int j3 = l2 & 0xF;
                int k3 = 0;
                double d1 = 0.0;
                if (world.p_().c()) {
                    int l3 = k2 + l2 * 231871;
                    if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                        multiset.add((Object)bzq.j.n().d((bvu)world, gg.b), 10);
                    } else {
                        multiset.add((Object)bzq.b.n().d((bvu)world, gg.b), 100);
                    }
                    d1 = 100.0;
                } else {
                    gg.a blockposition_mutableblockposition = new gg.a();
                    gg.a blockposition_mutableblockposition1 = new gg.a();
                    for (int i4 = 0; i4 < scale; ++i4) {
                        for (int j4 = 0; j4 < scale; ++j4) {
                            ckt iblockdata;
                            int k4 = chunk.a(cpt.a.b, i4 + i3, j4 + j3) + 1;
                            if (k4 <= world.s_() + 1) {
                                iblockdata = bzq.z.n();
                            } else {
                                do {
                                    blockposition_mutableblockposition.d(chunkcoordintpair.d() + i4 + i3, --k4, chunkcoordintpair.e() + j4 + j3);
                                } while ((iblockdata = chunk.a_((gg)blockposition_mutableblockposition)).d((bvu)world, (gg)blockposition_mutableblockposition) == dex.b && k4 > world.s_());
                                if (k4 > world.s_() && !ItemHelperImpl.blockStateFluidIsEmpty(iblockdata)) {
                                    ckt iblockdata1;
                                    int l4 = k4 - 1;
                                    blockposition_mutableblockposition1.g((hb)blockposition_mutableblockposition);
                                    do {
                                        blockposition_mutableblockposition1.t(l4--);
                                        iblockdata1 = chunk.a_((gg)blockposition_mutableblockposition1);
                                        ++k3;
                                    } while (l4 > world.s_() && !ItemHelperImpl.blockStateFluidIsEmpty(iblockdata1));
                                    iblockdata = ItemHelperImpl.getCorrectStateForFluidBlock((bwq)world, iblockdata, (gg)blockposition_mutableblockposition);
                                }
                            }
                            worldmap.a((bvu)world, chunkcoordintpair.d() + i4 + i3, chunkcoordintpair.e() + j4 + j3);
                            d1 += (double)k4 / (double)(scale * scale);
                            multiset.add((Object)iblockdata.d((bvu)world, (gg)blockposition_mutableblockposition));
                        }
                    }
                }
                k3 /= scale * scale;
                double d2 = (d1 - d0) * 4.0 / (double)(scale + 4) + ((double)(x + z & 1) - 0.5) * 0.4;
                int b0 = 1;
                if (d2 > 0.6) {
                    b0 = 2;
                }
                if (d2 < -0.6) {
                    b0 = 0;
                }
                if ((materialmapcolor = (dex)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)dex.b)) == dex.n) {
                    d2 = (double)k3 * 0.1 + (double)(x + z & 1) * 0.2;
                    b0 = 1;
                    if (d2 < 0.5) {
                        b0 = 2;
                    }
                    if (d2 > 0.9) {
                        b0 = 0;
                    }
                }
                d0 = d1;
                worldmap.a(x, z, (byte)(materialmapcolor.am * 4 + b0));
            }
        }
    }

    public boolean renderEntireMap(int mapId, int xMin, int zMin, int xMax, int zMax) {
        dhs worldmap = ((CraftServer)Bukkit.getServer()).getServer().a(bwq.f).a("map_" + mapId);
        if (worldmap == null) {
            return false;
        }
        ItemHelperImpl.renderFullMap(worldmap, xMin, zMin, xMax, zMax);
        return true;
    }

    public boolean isValidMix(ItemStack input, ItemStack ingredient) {
        bqq nmsInput = CraftItemStack.asNMSCopy((ItemStack)input);
        bqq nmsIngredient = CraftItemStack.asNMSCopy((ItemStack)ingredient);
        return bsm.a((bqq)nmsInput, (bqq)nmsIngredient);
    }
}

