/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.npc.traits;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.abstracts.ProfileEditor;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import java.util.UUID;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class MirrorTrait
extends Trait {
    @Persist(value="")
    public boolean mirror = true;

    public MirrorTrait() {
        super("mirror");
    }

    public void respawn() {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.getInstance(), () -> {
            if (this.npc.isSpawned()) {
                Location loc = this.npc.getStoredLocation().clone();
                this.npc.despawn(DespawnReason.PENDING_RESPAWN);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.getInstance(), () -> this.npc.spawn(loc));
            }
        });
    }

    public void mirrorOn() {
        NetworkInterceptHelper.enable();
        UUID uuid = this.npc.getUniqueId();
        if (!ProfileEditor.mirrorUUIDs.contains(uuid)) {
            ProfileEditor.mirrorUUIDs.add(uuid);
            this.respawn();
        }
    }

    public void mirrorOff() {
        UUID uuid = this.npc.getUniqueId();
        if (ProfileEditor.mirrorUUIDs.contains(uuid)) {
            ProfileEditor.mirrorUUIDs.remove(uuid);
            this.respawn();
        }
    }

    public void enableMirror() {
        this.mirror = true;
        this.mirrorOn();
    }

    public void disableMirror() {
        this.mirror = false;
        this.mirrorOff();
    }

    public void onSpawn() {
        if (this.mirror) {
            this.mirrorOn();
        }
    }

    public void onRemove() {
        if (this.mirror) {
            this.mirrorOff();
        }
    }

    public void onAttach() {
        if (this.mirror) {
            this.mirrorOn();
        }
    }
}

