/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_18.helpers;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.PacketHelper;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.JNBTListTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_18.Handler;
import com.denizenscript.denizen.nms.v1_18.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_18.impl.SidebarImpl;
import com.denizenscript.denizen.nms.v1_18.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.nms.v1_18.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.blocks.FakeBlock;
import com.denizenscript.denizen.utilities.maps.MapImage;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.map.CraftMapCanvas;
import org.bukkit.craftbukkit.v1_18_R2.map.CraftMapView;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapCanvas;

public class PacketHelperImpl
implements PacketHelper {
    public static final yb<Float> ENTITY_HUMAN_DATA_WATCHER_ABSORPTION = (yb)ReflectionHelper.getFieldValue(boj.class, (String)ReflectionMappingsInfo.Player_DATA_PLAYER_ABSORPTION_ID, null);
    public static final yb<Byte> ENTITY_DATA_WATCHER_FLAGS = (yb)ReflectionHelper.getFieldValue(axk.class, (String)ReflectionMappingsInfo.Entity_DATA_SHARED_FLAGS_ID, null);
    public static final MethodHandle ABILITIES_PACKET_FOV_SETTER = ReflectionHelper.getFinalSetter(te.class, (String)ReflectionMappingsInfo.ClientboundPlayerAbilitiesPacket_walkingSpeed);
    public static MethodHandle ENTITY_METADATA_LIST_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(uf.class, List.class);
    public static Field ENTITY_TRACKER_ENTRY_GETTER = ReflectionHelper.getFields(adj.b.class).getFirstOfType(adv.class);
    public static MethodHandle CANVAS_GET_BUFFER = ReflectionHelper.getMethodHandle(CraftMapCanvas.class, (String)"getBuffer", (Class[])new Class[0]);
    public static Field MAPVIEW_WORLDMAP = ReflectionHelper.getFields(CraftMapView.class).get((Object)"worldMap");
    public static MethodHandle BLOCK_ENTITY_DATA_PACKET_CONSTRUCTOR = ReflectionHelper.getConstructor(rq.class, (Class[])new Class[]{gj.class, cmt.class, ok.class});
    public static yb<Optional<qk>> ENTITY_CUSTOM_NAME_METADATA;
    public static yb<Boolean> ENTITY_CUSTOM_NAME_VISIBLE_METADATA;
    public static HashMap<UUID, HashMap<UUID, dqk>> noCollideTeamMap;

    public void setFakeAbsorption(Player player, float value) {
        ye dw = new ye(null);
        dw.a(ENTITY_HUMAN_DATA_WATCHER_ABSORPTION, (Object)Float.valueOf(value));
        PacketHelperImpl.send(player, (rc)new uf(player.getEntityId(), dw, true));
    }

    public void setSlot(Player player, int slot, ItemStack itemStack, boolean playerOnly) {
        bqp menu = ((CraftPlayer)player).getHandle().bV;
        int windowId = playerOnly ? 0 : menu.j;
        PacketHelperImpl.send(player, (rc)new sc(windowId, menu.k(), slot, CraftItemStack.asNMSCopy((ItemStack)itemStack)));
    }

    public void setFieldOfView(Player player, float fov) {
        te packet = new te(((CraftPlayer)player).getHandle().fs());
        if (!Float.isNaN(fov)) {
            try {
                ABILITIES_PACKET_FOV_SETTER.invoke(packet, fov);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
        PacketHelperImpl.send(player, (rc)packet);
    }

    public void respawn(Player player) {
        ((CraftPlayer)player).getHandle().b.a(new vo(vo.a.a));
    }

    public void setVision(Player player, EntityType entityType) {
        blp entity;
        if (entityType == EntityType.CREEPER) {
            entity = new blp(axo.o, (cav)((CraftWorld)player.getWorld()).getHandle());
        } else if (entityType == EntityType.SPIDER) {
            entity = new bmo(axo.aI, (cav)((CraftWorld)player.getWorld()).getHandle());
        } else if (entityType == EntityType.CAVE_SPIDER) {
            entity = new blo(axo.k, (cav)((CraftWorld)player.getWorld()).getHandle());
        } else if (entityType == EntityType.ENDERMAN) {
            entity = new blt(axo.w, (cav)((CraftWorld)player.getWorld()).getHandle());
        } else {
            return;
        }
        PacketHelperImpl.send(player, (rc)new ri((axy)entity));
        PacketHelperImpl.send(player, (rc)new tz((axk)entity));
        ((CraftServer)Bukkit.getServer()).getHandle().respawn(((CraftPlayer)player).getHandle(), ((CraftWorld)player.getWorld()).getHandle(), true, player.getLocation(), false);
    }

    public void showBlockAction(Player player, Location location, int action, int state) {
        gj position = new gj(location.getX(), location.getY(), location.getZ());
        cdq block = ((CraftWorld)location.getWorld()).getHandle().a_(position).b();
        PacketHelperImpl.send(player, (rc)new rr(position, block, action, state));
    }

    public void showBlockCrack(Player player, int id, Location location, int progress) {
        gj position = new gj(location.getX(), location.getY(), location.getZ());
        PacketHelperImpl.send(player, (rc)new rp(id, position, progress));
    }

    public void showTileEntityData(Player player, Location location, int action, CompoundTag compoundTag) {
        gj position = new gj(location.getX(), location.getY(), location.getZ());
        try {
            rq packet = BLOCK_ENTITY_DATA_PACKET_CONSTRUCTOR.invoke(position, action, ((CompoundTagImpl)compoundTag).toNMSTag());
            PacketHelperImpl.send(player, (rc)packet);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void showBannerUpdate(Player player, Location location, DyeColor base, List<Pattern> patterns) {
        ArrayList<CompoundTag> nbtPatterns = new ArrayList<CompoundTag>();
        for (Pattern pattern : patterns) {
            nbtPatterns.add(NMSHandler.instance.createCompoundTag(new HashMap()).createBuilder().putInt("Color", (int)pattern.getColor().getDyeData()).putString("Pattern", pattern.getPattern().getIdentifier()).build());
        }
        CompoundTag compoundTag = NMSHandler.blockHelper.getNbtData(location.getBlock()).createBuilder().put("Patterns", (Tag)new JNBTListTag(CompoundTag.class, nbtPatterns)).build();
        this.showTileEntityData(player, location, 3, compoundTag);
    }

    public void showTabListHeaderFooter(Player player, String header, String footer) {
        qq cHeader = Handler.componentToNMS(FormattedTextHelper.parse((String)header, (ChatColor)ChatColor.WHITE));
        qq cFooter = Handler.componentToNMS(FormattedTextHelper.parse((String)footer, (ChatColor)ChatColor.WHITE));
        ux packet = new ux((qk)cHeader, (qk)cFooter);
        PacketHelperImpl.send(player, (rc)packet);
    }

    public void showTitle(Player player, String title, String subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        PacketHelperImpl.send(player, (rc)new ut(fadeInTicks, stayTicks, fadeOutTicks));
        if (title != null) {
            PacketHelperImpl.send(player, (rc)new us((qk)Handler.componentToNMS(FormattedTextHelper.parse((String)title, (ChatColor)ChatColor.WHITE))));
        }
        if (subtitle != null) {
            PacketHelperImpl.send(player, (rc)new uq((qk)Handler.componentToNMS(FormattedTextHelper.parse((String)subtitle, (ChatColor)ChatColor.WHITE))));
        }
    }

    public void resetEquipment(Player player, LivingEntity entity) {
        EntityEquipment equipment = entity.getEquipment();
        ArrayList<Pair> pairList = new ArrayList<Pair>();
        pairList.add(new Pair((Object)axp.a, (Object)CraftItemStack.asNMSCopy((ItemStack)equipment.getItemInMainHand())));
        pairList.add(new Pair((Object)axp.b, (Object)CraftItemStack.asNMSCopy((ItemStack)equipment.getItemInOffHand())));
        pairList.add(new Pair((Object)axp.f, (Object)CraftItemStack.asNMSCopy((ItemStack)equipment.getHelmet())));
        pairList.add(new Pair((Object)axp.e, (Object)CraftItemStack.asNMSCopy((ItemStack)equipment.getChestplate())));
        pairList.add(new Pair((Object)axp.d, (Object)CraftItemStack.asNMSCopy((ItemStack)equipment.getLeggings())));
        pairList.add(new Pair((Object)axp.c, (Object)CraftItemStack.asNMSCopy((ItemStack)equipment.getBoots())));
        PacketHelperImpl.send(player, (rc)new ui(entity.getEntityId(), pairList));
    }

    public void showHealth(Player player, float health, int food, float saturation) {
        PacketHelperImpl.send(player, (rc)new uk(health, food, saturation));
    }

    public void showMobHealth(Player player, LivingEntity mob, double health, double maxHealth) {
        ayv attr = new ayv(ayz.a, a2 -> {});
        attr.a(maxHealth);
        PacketHelperImpl.send(player, (rc)new vc(mob.getEntityId(), Collections.singletonList(attr)));
        py healthData = new py(Unpooled.buffer());
        healthData.d(mob.getEntityId());
        healthData.writeByte(9);
        healthData.d(2);
        healthData.writeFloat((float)health);
        healthData.writeByte(255);
        PacketHelperImpl.send(player, (rc)new uf(healthData));
    }

    public void resetHealth(Player player) {
        this.showHealth(player, (float)player.getHealth(), player.getFoodLevel(), player.getSaturation());
    }

    public void showSignEditor(Player player, Location location) {
        gj pos;
        LocationTag fakeSign = new LocationTag(player.getLocation());
        fakeSign.setY(0.0);
        FakeBlock.showFakeBlockTo(Collections.singletonList(new PlayerTag(player)), (LocationTag)fakeSign, (MaterialTag)new MaterialTag(Material.OAK_WALL_SIGN), (DurationTag)new DurationTag(1), (boolean)true);
        ((DenizenNetworkManagerImpl)((CraftPlayer)player).getHandle().b.a).packetListener.fakeSignExpected = pos = new gj(fakeSign.getX(), 0.0, fakeSign.getZ());
        PacketHelperImpl.send(player, (rc)new tb(pos));
    }

    public void forceSpectate(Player player, Entity entity) {
        PacketHelperImpl.send(player, (rc)new tz(((CraftEntity)entity).getHandle()));
    }

    public static void forceRespawnPlayerEntity(Entity entity, Player viewer) {
        adj tracker = ((adw)((CraftEntity)entity).getHandle().s).k().a;
        adj.b entityTracker = (adj.b)tracker.J.get(entity.getEntityId());
        if (entityTracker != null) {
            try {
                adv entry = (adv)ENTITY_TRACKER_ENTRY_GETTER.get(entityTracker);
                if (entry != null) {
                    entry.a(((CraftPlayer)viewer).getHandle());
                    entry.b(((CraftPlayer)viewer).getHandle());
                }
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
    }

    public void sendRename(Player player, Entity entity, String name, boolean listMode) {
        try {
            if (entity.getType() == EntityType.PLAYER) {
                if (listMode) {
                    PacketHelperImpl.send(player, (rc)new ti(ti.a.d, new adx[]{((CraftPlayer)player).getHandle()}));
                } else {
                    PacketHelperImpl.forceRespawnPlayerEntity(entity, player);
                }
                return;
            }
            ye fakeData = new ye(((CraftEntity)entity).getHandle());
            uf packet = new uf(entity.getEntityId(), fakeData, false);
            ArrayList<ye.a> list = new ArrayList<ye.a>();
            list.add(new ye.a(ENTITY_CUSTOM_NAME_METADATA, Optional.of(Handler.componentToNMS(FormattedTextHelper.parse((String)name, (ChatColor)ChatColor.WHITE)))));
            list.add(new ye.a(ENTITY_CUSTOM_NAME_VISIBLE_METADATA, (Object)true));
            ENTITY_METADATA_LIST_SETTER.invoke(packet, list);
            PacketHelperImpl.send(player, (rc)packet);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void generateNoCollideTeam(Player player, UUID noCollide) {
        this.removeNoCollideTeam(player, noCollide);
        dqk team = new dqk(SidebarImpl.dummyScoreboard, Utilities.generateRandomColors((int)8));
        team.g().add(noCollide.toString());
        team.a(dqo.a.b);
        HashMap map = noCollideTeamMap.computeIfAbsent(player.getUniqueId(), k -> new HashMap());
        map.put(noCollide, team);
        PacketHelperImpl.send(player, (rc)un.a((dqk)team, (boolean)true));
    }

    public void removeNoCollideTeam(Player player, UUID noCollide) {
        if (noCollide == null || !player.isOnline()) {
            noCollideTeamMap.remove(player.getUniqueId());
            return;
        }
        HashMap<UUID, dqk> map = noCollideTeamMap.get(player.getUniqueId());
        if (map == null) {
            return;
        }
        dqk team = map.remove(noCollide);
        if (team != null) {
            PacketHelperImpl.send(player, (rc)un.a((dqk)team));
        }
        if (map.isEmpty()) {
            noCollideTeamMap.remove(player.getUniqueId());
        }
    }

    public void sendEntityMetadataFlagsUpdate(Player player, Entity entity) {
        ye dw = new ye(null);
        dw.a(ENTITY_DATA_WATCHER_FLAGS, (Object)((Byte)((CraftEntity)entity).getHandle().ai().a(ENTITY_DATA_WATCHER_FLAGS)));
        PacketHelperImpl.send(player, (rc)new uf(entity.getEntityId(), dw, true));
    }

    public void sendEntityEffect(Player player, Entity entity, byte effectId) {
        PacketHelperImpl.send(player, (rc)new sh(((CraftEntity)entity).getHandle(), effectId));
    }

    public int getPacketStats(Player player, boolean sent) {
        DenizenNetworkManagerImpl netMan = (DenizenNetworkManagerImpl)((CraftPlayer)player).getHandle().b.a;
        return sent ? netMan.packetsSent : netMan.packetsReceived;
    }

    public void setMapData(MapCanvas canvas, byte[] bytes, int x, int y, MapImage image) {
        if (x > 127 || y > 127) {
            return;
        }
        int width = Math.min(image.width, 128 - x);
        int height = Math.min(image.height, 128 - y);
        if (x + width <= 0 || y + height <= 0) {
            return;
        }
        try {
            int x2;
            boolean anyChanged = false;
            byte[] buffer = CANVAS_GET_BUFFER.invoke(canvas);
            int n = x2 = x < 0 ? -x : 0;
            while (x2 < width) {
                int y2;
                int n2 = y2 = y < 0 ? -y : 0;
                while (y2 < height) {
                    int index;
                    byte p = bytes[y2 * image.width + x2];
                    if (p != 0 && buffer[index = (y2 + y) * 128 + (x2 + x)] != p) {
                        buffer[index] = p;
                        anyChanged = true;
                    }
                    ++y2;
                }
                ++x2;
            }
            if (anyChanged) {
                dkf map = (dkf)MAPVIEW_WORLDMAP.get(canvas.getMapView());
                map.a(Math.max(x, 0), Math.max(y, 0));
                map.a(width + x - 1, height + y - 1);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setNetworkManagerFor(Player player) {
        DenizenNetworkManagerImpl.setNetworkManager(player);
    }

    public void enableNetworkManager() {
        DenizenNetworkManagerImpl.enableNetworkManager();
    }

    public void showDebugTestMarker(Player player, Location location, ColorTag color, String name, int time) {
        yt packetKey = new yt("minecraft", "debug/game_test_add_marker");
        py buf = new py(Unpooled.buffer());
        buf.a(new gj(location.getBlockX(), location.getBlockY(), location.getBlockZ()));
        int colorInt = color.blue | color.green << 8 | color.red << 16 | color.alpha << 24;
        buf.writeInt(colorInt);
        buf.a(name.getBytes(StandardCharsets.UTF_8));
        buf.writeInt(time);
        se packet = new se(packetKey, buf);
        PacketHelperImpl.send(player, (rc)packet);
    }

    public void clearDebugTestMarker(Player player) {
        yt packetKey = new yt("minecraft", "debug/game_test_clear");
        py buf = new py(Unpooled.buffer());
        se packet = new se(packetKey, buf);
        PacketHelperImpl.send(player, (rc)packet);
    }

    public void sendBrand(Player player, String brand) {
        yt packetKey = new yt("minecraft", "brand");
        py buf = new py(Unpooled.buffer());
        buf.a(brand);
        se packet = new se(packetKey, buf);
        PacketHelperImpl.send(player, (rc)packet);
    }

    public void sendCollectItemEntity(Player player, Entity taker, Entity item, int amount) {
        uz packet = new uz(item.getEntityId(), taker.getEntityId(), amount);
        PacketHelperImpl.send(player, (rc)packet);
    }

    public static void send(Player player, rc packet) {
        ((CraftPlayer)player).getHandle().b.a(packet);
    }

    static {
        try {
            ENTITY_CUSTOM_NAME_METADATA = (yb)ReflectionHelper.getFieldValue(axk.class, (String)ReflectionMappingsInfo.Entity_DATA_CUSTOM_NAME, null);
            ENTITY_CUSTOM_NAME_VISIBLE_METADATA = (yb)ReflectionHelper.getFieldValue(axk.class, (String)ReflectionMappingsInfo.Entity_DATA_CUSTOM_NAME_VISIBLE, null);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        noCollideTeamMap = new HashMap();
    }
}

