/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.events.core;

import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.List;

public class CustomScriptEvent
extends ScriptEvent {
    public static CustomScriptEvent instance;
    public ScriptEntryData entryData = null;
    public String id;
    public MapTag contextData;
    public boolean anyMatched = false;
    public ListTag determinations;
    boolean enabled = false;

    public CustomScriptEvent() {
        instance = this;
        this.registerCouldMatcher("custom event");
        this.registerSwitches("id", "data");
        this.registerDetermination("output", ObjectTag.class, (context, output) -> this.determinations.addObject((ObjectTag)output));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!CustomScriptEvent.runGenericSwitchCheck(path, "id", this.id)) {
            return false;
        }
        for (String switchText : path.rawSwitches) {
            if (!switchText.startsWith("data:")) continue;
            String compare = switchText.substring("data:".length());
            List<String> parts = CoreUtilities.split(compare, ':', 2);
            if (parts.size() != 2) {
                Debug.echoError("Invalid custom event switch (missing data key or value): " + switchText);
                return false;
            }
            if (this.contextData == null) {
                return false;
            }
            ObjectTag val = this.contextData.getDeepObject(parts.get(0));
            if (val == null) {
                return false;
            }
            if (val.tryAdvancedMatcher(parts.get(1))) continue;
            return false;
        }
        this.anyMatched = true;
        return true;
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return this.entryData;
    }

    @Override
    public ObjectTag getContext(String name) {
        ObjectTag val;
        switch (name) {
            case "id": {
                return new ElementTag(this.id, true);
            }
            case "data": {
                return this.contextData;
            }
        }
        if (this.contextData != null && (val = this.contextData.getObject(name)) != null) {
            return val;
        }
        return super.getContext(name);
    }

    @Override
    public void init() {
        this.enabled = true;
    }

    @Override
    public void destroy() {
        this.enabled = false;
    }

    public static CustomScriptEvent runCustomEvent(ScriptEntryData data, String id, MapTag contextData) {
        if (!CustomScriptEvent.instance.enabled) {
            return null;
        }
        CustomScriptEvent.instance.cancelled = false;
        CustomScriptEvent.instance.determinations = new ListTag();
        CustomScriptEvent.instance.entryData = data;
        CustomScriptEvent.instance.id = id;
        CustomScriptEvent.instance.contextData = contextData;
        return (CustomScriptEvent)instance.fire();
    }
}

